/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.processor;

import com.twitter.hbc.common.DelimitedStreamReader;
import com.twitter.hbc.core.processor.AbstractProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nullable;
import org.apache.flink.shaded.com.google.common.base.Charsets;

public class LineStringProcessor
extends AbstractProcessor<String> {
    private static final int DEFAULT_BUFFER_SIZE = 50000;
    private DelimitedStreamReader reader;

    public LineStringProcessor(BlockingQueue<String> queue) {
        super(queue);
    }

    public LineStringProcessor(BlockingQueue<String> queue, long offerTimeoutMillis) {
        super(queue, offerTimeoutMillis);
    }

    @Override
    @Nullable
    protected String processNextMessage() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new IOException("Unable to read new line from stream");
        }
        if (line.isEmpty()) {
            return null;
        }
        return line;
    }

    @Override
    public void setup(InputStream input) {
        this.reader = new DelimitedStreamReader(input, Charsets.UTF_8, 50000);
    }
}

