/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.event;

import com.twitter.hbc.core.event.EventType;
import javax.annotation.Nullable;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class Event {
    private final EventType eventType;
    private final String message;
    private final Exception exception;

    public Event(EventType eventType) {
        this(eventType, eventType.toString());
    }

    public Event(EventType eventType, String message) {
        this.eventType = Preconditions.checkNotNull(eventType);
        this.message = Preconditions.checkNotNull(message);
        this.exception = null;
    }

    public Event(EventType eventType, Exception exception) {
        this.eventType = Preconditions.checkNotNull(eventType);
        this.exception = Preconditions.checkNotNull(exception);
        this.message = exception.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    @Nullable
    public Exception getUnderlyingException() {
        return this.exception;
    }
}

