/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.twitter.hbc.core.endpoint.BaseEndpoint;
import com.twitter.hbc.core.endpoint.Endpoint;
import com.twitter.hbc.core.endpoint.UserstreamEndpoint;
import java.util.List;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class SitestreamEndpoint
extends UserstreamEndpoint {
    public static final String PATH = "/site.json";

    public SitestreamEndpoint(List<Long> userIds) {
        super(PATH);
        Preconditions.checkNotNull(userIds, "List of users to follow must be provided");
        Preconditions.checkArgument(userIds.size() > 0, "List of users to follow must not be empty");
        Preconditions.checkArgument(userIds.size() <= 100, "Number of users to follow must be less than or equal to 100");
        this.addQueryParameter("follow", Joiner.on(',').join(userIds));
    }

    public static Endpoint streamInfoEndpoint(String streamId) {
        return new BaseEndpoint("/site/c/" + streamId + "/info.json", "GET");
    }

    public static Endpoint addUserEndpoint(String streamId) {
        return new BaseEndpoint("/site/c/" + streamId + "/add_user.json", "POST");
    }

    public static Endpoint removeUserEndpoint(String streamId) {
        return new BaseEndpoint("/site/c/" + streamId + "/remove_user.json", "POST");
    }

    public static Endpoint friendsEndpoint(String streamId) {
        return new BaseEndpoint("/site/c/" + streamId + "/friends/ids.json", "POST");
    }
}

