/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.twitter.hbc.core.HttpConstants;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.joauth.UrlCodec;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.collect.Maps;

public class RawEndpoint
implements StreamingEndpoint {
    private final String uri;
    private final String httpMethod;
    private final ConcurrentMap<String, String> postParams;
    private final ConcurrentMap<String, String> queryParameters;

    public RawEndpoint(String uri, String httpMethod) {
        this(uri, httpMethod, Collections.emptyMap());
    }

    public RawEndpoint(String uri, String httpMethod, Map<String, String> postParams) {
        this.uri = Preconditions.checkNotNull(uri);
        this.httpMethod = Preconditions.checkNotNull(httpMethod);
        Preconditions.checkArgument(HttpConstants.checkHttpMethod(httpMethod));
        Preconditions.checkNotNull(postParams);
        this.postParams = Maps.newConcurrentMap();
        this.queryParameters = Maps.newConcurrentMap();
        postParams.putAll(postParams);
    }

    @Override
    public void setBackfillCount(int count) {
    }

    @Override
    public void setApiVersion(String apiVersion) {
    }

    @Override
    public String getURI() {
        if (this.queryParameters.isEmpty()) {
            return this.uri;
        }
        return this.uri + "?" + this.generateParamString(this.queryParameters);
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getPostParamString() {
        return Joiner.on("&").withKeyValueSeparator("=").join(this.postParams);
    }

    @Override
    public void addPostParameter(String param, String value) {
        this.postParams.put(UrlCodec.encode(param), UrlCodec.encode(value));
    }

    @Override
    public void removePostParameter(String param) {
        this.postParams.remove(UrlCodec.encode(param));
    }

    @Override
    public String getQueryParamString() {
        return this.generateParamString(this.queryParameters);
    }

    @Override
    public void addQueryParameter(String param, String value) {
        this.queryParameters.put(param, value);
    }

    @Override
    public void removeQueryParameter(String param) {
        this.queryParameters.remove(param);
    }

    private String generateParamString(Map<String, String> params) {
        return Joiner.on("&").withKeyValueSeparator("=").join(params);
    }
}

