/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.twitter.hbc.core.HttpConstants;
import com.twitter.hbc.core.endpoint.Endpoint;
import com.twitter.joauth.UrlCodec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class BaseEndpoint
implements Endpoint {
    protected final ConcurrentMap<String, String> queryParameters;
    protected final ConcurrentMap<String, String> postParameters;
    protected final String path;
    protected final String httpMethod;
    protected volatile String apiVersion;

    public BaseEndpoint(String path, String httpMethod) {
        this.path = Preconditions.checkNotNull(path);
        this.httpMethod = Preconditions.checkNotNull(httpMethod);
        Preconditions.checkArgument(HttpConstants.checkHttpMethod(httpMethod));
        this.queryParameters = new ConcurrentHashMap<String, String>();
        this.postParameters = new ConcurrentHashMap<String, String>();
        this.apiVersion = "1.1";
    }

    public String getPath(String apiVersion) {
        return "/" + apiVersion + this.path;
    }

    public final String getPath() {
        return this.getPath(this.apiVersion);
    }

    @Override
    public String getURI() {
        this.addDefaultParams();
        if (this.queryParameters.isEmpty()) {
            return this.getPath();
        }
        return this.getPath() + "?" + this.generateParamString(this.queryParameters);
    }

    protected void addDefaultParams() {
    }

    protected String generateParamString(Map<String, String> params) {
        return Joiner.on("&").withKeyValueSeparator("=").join(params);
    }

    @Override
    public String getQueryParamString() {
        return this.generateParamString(this.queryParameters);
    }

    @Override
    public String getPostParamString() {
        return this.generateParamString(this.postParameters);
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void addPostParameter(String param, String value) {
        this.postParameters.put(UrlCodec.encode(param), UrlCodec.encode(value));
    }

    @Override
    public void removePostParameter(String param) {
        this.postParameters.remove(UrlCodec.encode(param));
    }

    @Override
    public void addQueryParameter(String param, String value) {
        this.queryParameters.put(UrlCodec.encode(param), UrlCodec.encode(value));
    }

    @Override
    public void removeQueryParameter(String param) {
        this.queryParameters.remove(UrlCodec.encode(param));
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = Preconditions.checkNotNull(apiVersion);
    }
}

