/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core;

import com.twitter.hbc.core.Hosts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.collect.Iterables;
import org.apache.flink.shaded.com.google.common.collect.Iterators;
import org.apache.flink.shaded.com.google.common.collect.Lists;

public class HttpHosts
implements Hosts {
    private final Iterator<String> hosts;
    public static final HttpHosts STREAM_HOST = new HttpHosts("https://stream.twitter.com");
    public static final HttpHosts USERSTREAM_HOST = new HttpHosts("https://userstream.twitter.com");
    public static final HttpHosts SITESTREAM_HOST = new HttpHosts("https://sitestream.twitter.com");

    public HttpHosts(String address) {
        this(Collections.singletonList(address));
    }

    public HttpHosts(Iterable<String> addresses) {
        Preconditions.checkNotNull(addresses);
        Preconditions.checkArgument(!Iterables.isEmpty(addresses));
        for (String address : addresses) {
            if (address.toLowerCase().startsWith("http://") || address.toLowerCase().startsWith("https://")) continue;
            throw new IllegalArgumentException("Address doesn't have an http scheme: " + address);
        }
        ArrayList<String> copy = Lists.newArrayList(addresses);
        Collections.shuffle(copy);
        this.hosts = Iterators.cycle(copy);
    }

    @Override
    public String nextHost() {
        return this.hosts.next();
    }
}

