/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class DelimitedStreamReader {
    private final InputStream inputStream;
    private final byte[] buffer;
    private byte[] strBuffer;
    private int strBufferIndex;
    private final Charset charset;
    private int offset;
    private int end;
    private static final int DEFAULT_READ_COUNT = 64;
    private static final int MAX_ALLOWABLE_BUFFER_SIZE = 500000;
    private static final byte CR = 13;
    private static final byte LF = 10;

    public DelimitedStreamReader(InputStream stream, Charset charset, int bufferSize) {
        Preconditions.checkArgument(bufferSize > 0);
        this.inputStream = Preconditions.checkNotNull(stream);
        this.charset = Preconditions.checkNotNull(charset);
        this.strBuffer = new byte[bufferSize * 2];
        this.buffer = new byte[bufferSize];
        this.offset = 0;
        this.end = 0;
    }

    public String readLine() throws IOException {
        return this.readLine(true);
    }

    private String readLine(boolean trim) throws IOException {
        boolean done = false;
        boolean sawCarriage = false;
        int removalBytes = 0;
        while (!done) {
            if (this.isReadBufferEmpty()) {
                this.offset = 0;
                this.end = 0;
                int bytesRead = this.inputStream.read(this.buffer, this.end, Math.min(64, this.buffer.length - this.end));
                if (bytesRead < 0) {
                    throw new IOException("Reached the end of the stream");
                }
                this.end += bytesRead;
            }
            int originalOffset = this.offset;
            while (!done && this.offset < this.end) {
                if (this.buffer[this.offset] == 10) {
                    int cpLength = this.offset - originalOffset + 1;
                    if (trim) {
                        int length = 0;
                        if (this.buffer[this.offset] == 10) {
                            ++length;
                            if (sawCarriage) {
                                ++length;
                            }
                        }
                        cpLength -= length;
                    }
                    if (cpLength > 0) {
                        this.copyToStrBuffer(this.buffer, originalOffset, cpLength);
                    } else {
                        removalBytes = cpLength;
                    }
                    done = true;
                } else {
                    sawCarriage = this.buffer[this.offset] == 13;
                }
                ++this.offset;
            }
            if (done) continue;
            this.copyToStrBuffer(this.buffer, originalOffset, this.end - originalOffset);
            this.offset = this.end;
        }
        int strLength = this.strBufferIndex + removalBytes;
        this.strBufferIndex = 0;
        return new String(this.strBuffer, 0, strLength, this.charset);
    }

    private void copyToStrBuffer(byte[] buffer, int offset, int length) {
        Preconditions.checkArgument(length >= 0);
        if (this.strBuffer.length - this.strBufferIndex < length) {
            this.expandStrBuffer(length);
        }
        System.arraycopy(buffer, offset, this.strBuffer, this.strBufferIndex, Math.min(length, 500000 - this.strBufferIndex));
        this.strBufferIndex += length;
    }

    private void expandStrBuffer(int minLength) {
        byte[] oldBuffer = this.strBuffer;
        int newLength = Math.min(Math.max(oldBuffer.length * 2, minLength), 500000);
        if (newLength > oldBuffer.length) {
            this.strBuffer = new byte[newLength];
            System.arraycopy(oldBuffer, 0, this.strBuffer, 0, this.strBufferIndex);
        }
    }

    public String read(int numBytes) throws IOException {
        Preconditions.checkArgument(numBytes >= 0);
        Preconditions.checkArgument(numBytes <= 500000);
        int numBytesRemaining = numBytes;
        if (!this.isReadBufferEmpty()) {
            int length = Math.min(this.end - this.offset, numBytesRemaining);
            this.copyToStrBuffer(this.buffer, this.offset, length);
            this.offset += length;
            numBytesRemaining -= length;
        }
        if (numBytesRemaining > 0) {
            this.readAmountToStrBuffer(numBytesRemaining);
        }
        if (this.strBufferIndex > 0 && this.strBuffer[this.strBufferIndex - 1] != 10) {
            return this.readLine(false);
        }
        int strBufferLength = this.strBufferIndex;
        this.strBufferIndex = 0;
        return new String(this.strBuffer, 0, strBufferLength, this.charset);
    }

    private void readAmountToStrBuffer(int length) throws IOException {
        int bytesRead;
        for (int remainingBytes = length; remainingBytes > 0; remainingBytes -= bytesRead) {
            bytesRead = this.readStreamToStrBuffer(remainingBytes);
        }
    }

    private int readStreamToStrBuffer(int length) throws IOException {
        int bytesRead;
        if (length > this.strBuffer.length - this.strBufferIndex) {
            this.expandStrBuffer(length);
        }
        if ((bytesRead = this.inputStream.read(this.strBuffer, this.strBufferIndex, Math.min(length, this.strBuffer.length - this.strBufferIndex))) < 0) {
            throw new IOException("Reached end of stream.");
        }
        this.strBufferIndex += bytesRead;
        return bytesRead;
    }

    private boolean isReadBufferEmpty() {
        return this.offset >= this.buffer.length || this.end - this.offset <= 0;
    }
}

