/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc;

import com.twitter.hbc.core.Constants;
import com.twitter.hbc.core.Hosts;
import com.twitter.hbc.core.HttpConstants;
import com.twitter.hbc.core.HttpHosts;
import com.twitter.hbc.core.endpoint.Endpoint;
import com.twitter.hbc.core.endpoint.SitestreamEndpoint;
import com.twitter.hbc.httpclient.ControlStreamException;
import com.twitter.hbc.httpclient.auth.Authentication;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.io.CharStreams;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitestreamController {
    private static final Logger logger = LoggerFactory.getLogger(SitestreamController.class);
    private final HttpClient client;
    private final Authentication auth;
    private final Hosts hosts;

    public SitestreamController(HttpClient client, Hosts hosts, Authentication auth) {
        this.client = Preconditions.checkNotNull(client);
        this.hosts = Preconditions.checkNotNull(hosts);
        this.auth = Preconditions.checkNotNull(auth);
    }

    public SitestreamController(HttpClient client, Authentication auth) {
        this.client = Preconditions.checkNotNull(client);
        this.hosts = new HttpHosts("https://sitestream.twitter.com");
        this.auth = Preconditions.checkNotNull(auth);
    }

    public SitestreamController(Hosts hosts, Authentication auth) {
        this.client = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        this.hosts = Preconditions.checkNotNull(hosts);
        this.auth = Preconditions.checkNotNull(auth);
    }

    public SitestreamController(Authentication auth) {
        this.client = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        this.hosts = new HttpHosts("https://sitestream.twitter.com");
        this.auth = Preconditions.checkNotNull(auth);
    }

    public void addUser(String streamId, long userId) throws IOException, ControlStreamException {
        Endpoint endpoint = SitestreamEndpoint.addUserEndpoint(streamId);
        endpoint.addPostParameter("user_id", Long.toString(userId));
        HttpUriRequest request = HttpConstants.constructRequest(this.hosts.nextHost(), endpoint, this.auth);
        this.consumeHttpEntityContent(this.makeControlStreamRequest(request));
    }

    public void removeUser(String streamId, long userId) throws IOException, ControlStreamException {
        Endpoint endpoint = SitestreamEndpoint.removeUserEndpoint(streamId);
        endpoint.addPostParameter("user_id", Long.toString(userId));
        HttpUriRequest request = HttpConstants.constructRequest(this.hosts.nextHost(), endpoint, this.auth);
        this.consumeHttpEntityContent(this.makeControlStreamRequest(request));
    }

    public void addUsers(String streamId, Collection<Long> userIds) throws IOException, ControlStreamException {
        Preconditions.checkArgument(userIds.size() >= 1 && userIds.size() <= 100, "The userId parameter can be supplied with up to 100 user IDs.");
        Endpoint endpoint = SitestreamEndpoint.addUserEndpoint(streamId);
        endpoint.addPostParameter("user_id", Joiner.on(',').join(userIds));
        HttpUriRequest request = HttpConstants.constructRequest(this.hosts.nextHost(), endpoint, this.auth);
        this.consumeHttpEntityContent(this.makeControlStreamRequest(request));
    }

    public void removeUsers(String streamId, Collection<Long> userIds) throws IOException, ControlStreamException {
        Preconditions.checkArgument(userIds.size() >= 1 && userIds.size() <= 100, "The userId parameter can be supplied with up to 100 user IDs.");
        Endpoint endpoint = SitestreamEndpoint.removeUserEndpoint(streamId);
        endpoint.addPostParameter("user_id", Joiner.on(',').join(userIds));
        HttpUriRequest request = HttpConstants.constructRequest(this.hosts.nextHost(), endpoint, this.auth);
        this.consumeHttpEntityContent(this.makeControlStreamRequest(request));
    }

    public String getFriends(String streamId, long userId) throws IOException, ControlStreamException {
        return this.getFriends(streamId, userId, 0);
    }

    public String getFriends(String streamId, long userId, int cursor) throws IOException, ControlStreamException {
        Endpoint endpoint = SitestreamEndpoint.friendsEndpoint(streamId);
        endpoint.addPostParameter("user_id", Long.toString(userId));
        endpoint.addPostParameter("cursor", Integer.toString(cursor));
        HttpUriRequest request = HttpConstants.constructRequest(this.hosts.nextHost(), endpoint, this.auth);
        HttpResponse response = this.makeControlStreamRequest(request);
        return this.consumeHttpEntityContent(response);
    }

    @Deprecated
    public String getInfo(String streamId, long userId) throws IOException, ControlStreamException {
        return this.getInfo(streamId);
    }

    public String getInfo(String streamId) throws IOException, ControlStreamException {
        Endpoint endpoint = SitestreamEndpoint.streamInfoEndpoint(streamId);
        HttpUriRequest request = HttpConstants.constructRequest(this.hosts.nextHost(), endpoint, this.auth);
        HttpResponse response = this.makeControlStreamRequest(request);
        return this.consumeHttpEntityContent(response);
    }

    @VisibleForTesting
    HttpResponse makeControlStreamRequest(HttpUriRequest request) throws IOException, ControlStreamException {
        HttpResponse response = this.client.execute(request);
        if (response.getStatusLine() == null) {
            throw new ControlStreamException("No status line in response");
        }
        logger.debug("{} returned with status line: {}", (Object)request.getURI(), (Object)response.getStatusLine());
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("{} returned with status code {}", (Object)request.getURI(), (Object)response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            throw new ControlStreamException(response.getStatusLine());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    String consumeHttpEntityContent(HttpResponse response) throws IOException {
        InputStream contentStream = response.getEntity().getContent();
        try {
            String string = CharStreams.toString(new InputStreamReader(contentStream, Constants.DEFAULT_CHARSET));
            return string;
        }
        finally {
            contentStream.close();
        }
    }
}

