/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc;

import com.twitter.hbc.BasicRateTracker;
import com.twitter.hbc.BasicReconnectionManager;
import com.twitter.hbc.RateTracker;
import com.twitter.hbc.ReconnectionManager;
import com.twitter.hbc.core.Hosts;
import com.twitter.hbc.core.HttpHosts;
import com.twitter.hbc.core.endpoint.RawEndpoint;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.hbc.core.event.Event;
import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import com.twitter.hbc.httpclient.BasicClient;
import com.twitter.hbc.httpclient.auth.Authentication;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ClientBuilder {
    private static final AtomicInteger clientNum = new AtomicInteger(0);
    protected Authentication auth;
    protected Hosts hosts;
    protected HosebirdMessageProcessor processor;
    protected StreamingEndpoint endpoint;
    protected boolean enableGZip = true;
    protected String name = "hosebird-client-" + clientNum.getAndIncrement();
    protected RateTracker rateTracker;
    protected final ExecutorService executorService;
    protected BlockingQueue<Event> eventQueue;
    protected ReconnectionManager reconnectionManager;
    protected int socketTimeoutMillis;
    protected int connectionTimeoutMillis;
    protected SchemeRegistry schemeRegistry;
    private static final String USER_AGENT = ClientBuilder.loadVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadVersion() {
        String userAgent = "Hosebird-Client";
        try {
            InputStream stream = ClientBuilder.class.getClassLoader().getResourceAsStream("build.properties");
            try {
                Properties prop = new Properties();
                prop.load(stream);
                String version = prop.getProperty("version");
                userAgent = userAgent + " " + version;
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return userAgent;
    }

    public ClientBuilder() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hosebird-client-io-thread-%d").build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        ThreadFactory rateTrackerThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hosebird-client-rateTracker-thread-%d").build();
        ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, rateTrackerThreadFactory);
        this.rateTracker = new BasicRateTracker(30000, 100, true, scheduledExecutor);
        this.reconnectionManager = new BasicReconnectionManager(5);
        this.socketTimeoutMillis = 60000;
        this.connectionTimeoutMillis = 4000;
        this.schemeRegistry = SchemeRegistryFactory.createDefault();
    }

    public ClientBuilder name(String name) {
        this.name = Preconditions.checkNotNull(name);
        return this;
    }

    public ClientBuilder gzipEnabled(boolean gzip) {
        this.enableGZip = gzip;
        return this;
    }

    public ClientBuilder hosts(String host) {
        this.hosts = new HttpHosts(Preconditions.checkNotNull(host));
        return this;
    }

    public ClientBuilder hosts(Hosts hosts) {
        this.hosts = Preconditions.checkNotNull(hosts);
        return this;
    }

    public ClientBuilder endpoint(StreamingEndpoint endpoint) {
        this.endpoint = Preconditions.checkNotNull(endpoint);
        return this;
    }

    public ClientBuilder authentication(Authentication auth) {
        this.auth = auth;
        return this;
    }

    public ClientBuilder processor(HosebirdMessageProcessor processor) {
        this.processor = processor;
        return this;
    }

    public ClientBuilder eventMessageQueue(BlockingQueue<Event> events) {
        this.eventQueue = events;
        return this;
    }

    public ClientBuilder socketTimeout(int millis) {
        this.socketTimeoutMillis = millis;
        return this;
    }

    public ClientBuilder connectionTimeout(int millis) {
        this.connectionTimeoutMillis = millis;
        return this;
    }

    public ClientBuilder retries(int retries) {
        this.reconnectionManager = new BasicReconnectionManager(retries);
        return this;
    }

    public ClientBuilder reconnectionManager(ReconnectionManager manager) {
        this.reconnectionManager = Preconditions.checkNotNull(manager);
        return this;
    }

    public ClientBuilder endpoint(String uri, String httpMethod) {
        Preconditions.checkNotNull(uri);
        this.endpoint = new RawEndpoint(uri, httpMethod);
        return this;
    }

    public ClientBuilder rateTracker(RateTracker rateTracker) {
        this.rateTracker = Preconditions.checkNotNull(rateTracker);
        return this;
    }

    public ClientBuilder schemeRegistry(SchemeRegistry schemeRegistry) {
        this.schemeRegistry = Preconditions.checkNotNull(schemeRegistry);
        return this;
    }

    public BasicClient build() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)USER_AGENT);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeoutMillis);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeoutMillis);
        return new BasicClient(this.name, this.hosts, this.endpoint, this.auth, this.enableGZip, this.processor, this.reconnectionManager, this.rateTracker, this.executorService, this.eventQueue, (HttpParams)params, this.schemeRegistry);
    }
}

