/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.container;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.streaming.connectors.redis.common.container.RedisCommandsContainer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;

public class RedisContainer
implements RedisCommandsContainer,
Closeable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RedisContainer.class);
    private final JedisPool jedisPool;
    private final JedisSentinelPool jedisSentinelPool;

    public RedisContainer(JedisPool jedisPool) {
        Preconditions.checkNotNull((Object)jedisPool, (String)"Jedis Pool can not be null");
        this.jedisPool = jedisPool;
        this.jedisSentinelPool = null;
    }

    public RedisContainer(JedisSentinelPool sentinelPool) {
        Preconditions.checkNotNull((Object)sentinelPool, (String)"Jedis Sentinel Pool can not be null");
        this.jedisPool = null;
        this.jedisSentinelPool = sentinelPool;
    }

    @Override
    public void close() throws IOException {
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
        if (this.jedisSentinelPool != null) {
            this.jedisSentinelPool.close();
        }
    }

    @Override
    public void hset(String key, String hashField, String value) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.hset(key, hashField, value);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command HSET to key {} and hashField {} error message {}", new Object[]{key, hashField, e.getMessage()});
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void rpush(String listName, String value) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.rpush(listName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command RPUSH to list {} error message {}", (Object)listName, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void lpush(String listName, String value) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.lpush(listName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command LUSH to list {} error message {}", (Object)listName, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void sadd(String setName, String value) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.sadd(setName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command RPUSH to set {} error message {}", (Object)setName, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void publish(String channelName, String message) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.publish(channelName, message);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command PUBLISH to channel {} error message {}", (Object)channelName, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.set(key, value);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command SET to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void pfadd(String key, String element) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.pfadd(key, new String[]{element});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command PFADD to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void zadd(String key, String score, String element) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            jedis.zadd(key, Double.valueOf(score).doubleValue(), element);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command ZADD to set {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    private Jedis getInstance() {
        if (this.jedisSentinelPool != null) {
            return this.jedisSentinelPool.getResource();
        }
        return this.jedisPool.getResource();
    }

    private void releaseInstance(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        try {
            jedis.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close (return) instance to pool", (Throwable)e);
        }
    }
}

