/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.container;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.streaming.connectors.redis.common.container.RedisCommandsContainer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class RedisClusterContainer
implements RedisCommandsContainer,
Closeable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterContainer.class);
    private JedisCluster jedisCluster;

    public RedisClusterContainer(JedisCluster jedisCluster) {
        Preconditions.checkNotNull((Object)jedisCluster, (String)"Jedis cluster can not be null");
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void hset(String key, String hashField, String value) {
        try {
            this.jedisCluster.hset(key, hashField, value);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command HSET to hash {} error message {}", new Object[]{key, hashField, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void rpush(String listName, String value) {
        try {
            this.jedisCluster.rpush(listName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command RPUSH to list {} error message: {}", (Object)listName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void lpush(String listName, String value) {
        try {
            this.jedisCluster.lpush(listName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command LPUSH to list {} error message: {}", (Object)listName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void sadd(String setName, String value) {
        try {
            this.jedisCluster.sadd(setName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command RPUSH to set {} error message {}", (Object)setName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void publish(String channelName, String message) {
        try {
            this.jedisCluster.publish(channelName, message);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command PUBLISH to channel {} error message {}", (Object)channelName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void set(String key, String value) {
        try {
            this.jedisCluster.set(key, value);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command SET to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void pfadd(String key, String element) {
        try {
            this.jedisCluster.set(key, element);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command PFADD to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void zadd(String key, String score, String element) {
        try {
            this.jedisCluster.zadd(key, Double.valueOf(score).doubleValue(), element);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command ZADD to set {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.jedisCluster.close();
    }
}

