/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkJedisSentinelConfig
extends FlinkJedisConfigBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkJedisSentinelConfig.class);
    private final String masterName;
    private final Set<String> sentinels;
    private final int soTimeout;
    private final String password;
    private final int database;

    private FlinkJedisSentinelConfig(String masterName, Set<String> sentinels, int connectionTimeout, int soTimeout, String password, int database, int maxTotal, int maxIdle, int minIdle) {
        super(connectionTimeout, maxTotal, maxIdle, minIdle);
        Preconditions.checkNotNull((Object)masterName, (String)"Master name should be presented");
        Preconditions.checkNotNull(sentinels, (String)"Sentinels information should be presented");
        Preconditions.checkArgument((!sentinels.isEmpty() ? 1 : 0) != 0, (Object)"Sentinel hosts should not be empty");
        this.masterName = masterName;
        this.sentinels = new HashSet<String>(sentinels);
        this.soTimeout = soTimeout;
        this.password = password;
        this.database = database;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public Set<String> getSentinels() {
        return this.sentinels;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDatabase() {
        return this.database;
    }

    public String toString() {
        return "JedisSentinelConfig{masterName='" + this.masterName + '\'' + ", connectionTimeout=" + this.connectionTimeout + ", soTimeout=" + this.soTimeout + ", database=" + this.database + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + '}';
    }

    public static class Builder {
        private String masterName;
        private Set<String> sentinels;
        private int connectionTimeout = 2000;
        private int soTimeout = 2000;
        private String password;
        private int database = 0;
        private int maxTotal = 8;
        private int maxIdle = 8;
        private int minIdle = 0;

        public Builder setMasterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public Builder setSentinels(Set<String> sentinels) {
            this.sentinels = sentinels;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSoTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDatabase(int database) {
            this.database = database;
            return this;
        }

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public Builder setMinIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public FlinkJedisSentinelConfig build() {
            return new FlinkJedisSentinelConfig(this.masterName, this.sentinels, this.connectionTimeout, this.soTimeout, this.password, this.database, this.maxTotal, this.maxIdle, this.minIdle);
        }
    }
}

