/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public abstract class FlinkJedisConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int maxTotal;
    protected final int maxIdle;
    protected final int minIdle;
    protected final int connectionTimeout;

    protected FlinkJedisConfigBase(int connectionTimeout, int maxTotal, int maxIdle, int minIdle) {
        Preconditions.checkArgument((connectionTimeout >= 0 ? 1 : 0) != 0, (Object)"connection timeout can not be negative");
        Preconditions.checkArgument((maxTotal >= 0 ? 1 : 0) != 0, (Object)"maxTotal value can not be negative");
        Preconditions.checkArgument((maxIdle >= 0 ? 1 : 0) != 0, (Object)"maxIdle value can not be negative");
        Preconditions.checkArgument((minIdle >= 0 ? 1 : 0) != 0, (Object)"minIdle value can not be negative");
        this.connectionTimeout = connectionTimeout;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }
}

