/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.rabbitmq.RMQSink;
import org.apache.flink.streaming.connectors.rabbitmq.RMQSource;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.apache.flink.streaming.util.serialization.SimpleStringSchema;

public class RMQTopology {
    public static void main(String[] args) throws Exception {
        LocalStreamEnvironment env = StreamExecutionEnvironment.createLocalEnvironment((int)1);
        DataStreamSink dataStream1 = env.addSource(new RMQSource("localhost", "hello", new SimpleStringSchema())).print();
        DataStreamSink dataStream2 = env.fromElements((Object[])new String[]{"one", "two", "three", "four", "five", "q"}).addSink(new RMQSink<String>("localhost", "hello", new StringToByteSerializer()));
        env.execute();
    }

    public static class StringToByteSerializer
    implements SerializationSchema<String, byte[]> {
        private static final long serialVersionUID = 1L;

        public byte[] serialize(String element) {
            return element.getBytes();
        }
    }
}

