/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.ConnectorSource;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;

public class RMQSource<OUT>
extends ConnectorSource<OUT> {
    private static final long serialVersionUID = 1L;
    private final String QUEUE_NAME;
    private final String HOST_NAME;
    private transient ConnectionFactory factory;
    private transient Connection connection;
    private transient Channel channel;
    private transient QueueingConsumer consumer;
    private transient QueueingConsumer.Delivery delivery;
    private volatile transient boolean running;

    public RMQSource(String HOST_NAME, String QUEUE_NAME, DeserializationSchema<OUT> deserializationSchema) {
        super(deserializationSchema);
        this.HOST_NAME = HOST_NAME;
        this.QUEUE_NAME = QUEUE_NAME;
    }

    private void initializeConnection() {
        this.factory = new ConnectionFactory();
        this.factory.setHost(this.HOST_NAME);
        try {
            this.connection = this.factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.queueDeclare(this.QUEUE_NAME, false, false, false, null);
            this.consumer = new QueueingConsumer(this.channel);
            this.channel.basicConsume(this.QUEUE_NAME, true, (Consumer)this.consumer);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create RMQ connection with " + this.QUEUE_NAME + " at " + this.HOST_NAME, e);
        }
    }

    public void open(Configuration config) throws Exception {
        this.initializeConnection();
        this.running = true;
    }

    public void close() throws Exception {
        super.close();
        try {
            this.connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing RMQ connection with " + this.QUEUE_NAME + " at " + this.HOST_NAME, e);
        }
    }

    public void run(SourceFunction.SourceContext<OUT> ctx) throws Exception {
        while (this.running) {
            this.delivery = this.consumer.nextDelivery();
            Object result = this.schema.deserialize(this.delivery.getBody());
            if (this.schema.isEndOfStream(result)) break;
            ctx.collect(result);
        }
    }

    public void cancel() {
        this.running = false;
    }
}

