/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQSink<IN>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RMQSink.class);
    private String QUEUE_NAME;
    private String HOST_NAME;
    private transient ConnectionFactory factory;
    private transient Connection connection;
    private transient Channel channel;
    private SerializationSchema<IN, byte[]> schema;

    public RMQSink(String HOST_NAME, String QUEUE_NAME, SerializationSchema<IN, byte[]> schema) {
        this.HOST_NAME = HOST_NAME;
        this.QUEUE_NAME = QUEUE_NAME;
        this.schema = schema;
    }

    public void initializeConnection() {
        this.factory = new ConnectionFactory();
        this.factory.setHost(this.HOST_NAME);
        try {
            this.connection = this.factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.queueDeclare(this.QUEUE_NAME, false, false, false, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void invoke(IN value) {
        block2: {
            try {
                byte[] msg = (byte[])this.schema.serialize(value);
                this.channel.basicPublish("", this.QUEUE_NAME, null, msg);
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Cannot send RMQ message {} at {}", (Object)this.QUEUE_NAME, (Object)this.HOST_NAME);
            }
        }
    }

    private void closeChannel() {
        try {
            this.channel.close();
            this.connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing RMQ connection with " + this.QUEUE_NAME + " at " + this.HOST_NAME, e);
        }
    }

    public void open(Configuration config) {
        this.initializeConnection();
    }

    public void close() {
        this.closeChannel();
    }
}

