/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle.util;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import oracle.sql.ROWID;
import org.apache.flink.cdc.connectors.oracle.source.utils.OracleTypeUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static RowType getSplitType(Column splitColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)splitColumn.name(), (DataType)OracleTypeUtils.fromDbzColumn(splitColumn))}).getLogicalType();
    }

    public static Column getChunkKeyColumn(Table table, @Nullable String chunkKeyColumn) {
        List primaryKeys = table.primaryKeyColumns();
        if (chunkKeyColumn != null) {
            Optional<Column> targetPkColumn = primaryKeys.stream().filter(col -> chunkKeyColumn.equals(col.name())).findFirst();
            if (targetPkColumn.isPresent()) {
                return targetPkColumn.get();
            }
            throw new ValidationException(String.format("Chunk key column '%s' doesn't exist in the primary key [%s] of the table %s.", chunkKeyColumn, primaryKeys.stream().map(Column::name).collect(Collectors.joining(",")), table.id()));
        }
        return Column.editor().jdbcType(12).name(ROWID.class.getSimpleName()).create();
    }
}

