/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle.source.utils;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.Scn;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.cdc.connectors.oracle.source.meta.offset.RedoLogOffset;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OracleConnectionUtils.class);
    private static final int ORACLE_UNSET_SCALE = -127;
    private static final String SHOW_CURRENT_SCN = "SELECT CURRENT_SCN FROM V$DATABASE";

    public static OracleConnection createOracleConnection(Configuration configuration) {
        return OracleConnectionUtils.createOracleConnection(JdbcConfiguration.adapt((Configuration)configuration));
    }

    public static OracleConnection createOracleConnection(JdbcConfiguration dbzConfiguration) {
        Configuration configuration = dbzConfiguration.subset("database.", true);
        return new OracleConnection(configuration.isEmpty() ? dbzConfiguration : JdbcConfiguration.adapt((Configuration)configuration), OracleConnectionUtils.class::getClassLoader);
    }

    public static RedoLogOffset currentRedoLogOffset(JdbcConnection jdbc) {
        try {
            return (RedoLogOffset)((Object)jdbc.queryAndMap(SHOW_CURRENT_SCN, rs -> {
                if (rs.next()) {
                    String scn = rs.getString(1);
                    return new RedoLogOffset(Scn.valueOf((String)scn).longValue());
                }
                throw new FlinkRuntimeException("Cannot read the scn via 'SELECT CURRENT_SCN FROM V$DATABASE'. Make sure your server is correctly configured");
            }));
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Cannot read the redo log position via 'SELECT CURRENT_SCN FROM V$DATABASE'. Make sure your server is correctly configured", (Throwable)e);
        }
    }

    public static List<TableId> listTables(JdbcConnection jdbcConnection, RelationalTableFilters tableFilters) throws SQLException {
        ArrayList<TableId> capturedTableIds = new ArrayList<TableId>();
        HashSet tableIdSet = new HashSet();
        String queryTablesSql = "SELECT OWNER ,TABLE_NAME,TABLESPACE_NAME FROM ALL_TABLES \nWHERE TABLESPACE_NAME IS NOT NULL AND TABLESPACE_NAME NOT IN ('SYSTEM','SYSAUX') AND NESTED = 'NO' AND TABLE_NAME NOT IN (SELECT PARENT_TABLE_NAME FROM ALL_NESTED_TABLES)";
        try {
            jdbcConnection.query(queryTablesSql, rs -> {
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    TableId tableId = new TableId(jdbcConnection.database(), schemaName, tableName);
                    tableIdSet.add(tableId);
                }
            });
        }
        catch (SQLException e) {
            LOG.warn(" SQL execute error, sql:{}", (Object)queryTablesSql, (Object)e);
        }
        for (TableId tableId : tableIdSet) {
            if (tableFilters.dataCollectionFilter().isIncluded(tableId)) {
                capturedTableIds.add(tableId);
                LOG.info("\t including '{}' for further processing", (Object)tableId);
                continue;
            }
            LOG.debug("\t '{}' is filtered out of capturing", (Object)tableId);
        }
        return capturedTableIds;
    }
}

