/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle.source.reader.fetch;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.logminer.LogMinerOracleOffsetContextLoader;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import org.apache.flink.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.apache.flink.cdc.connectors.base.source.reader.external.AbstractScanFetchTask;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.oracle.source.reader.fetch.OracleSourceFetchTaskContext;
import org.apache.flink.cdc.connectors.oracle.source.reader.fetch.OracleStreamFetchTask;
import org.apache.flink.cdc.connectors.oracle.source.reader.fetch.StoppableChangeEventSourceContext;
import org.apache.flink.cdc.connectors.oracle.source.utils.OracleUtils;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleScanFetchTask
extends AbstractScanFetchTask {
    public OracleScanFetchTask(SnapshotSplit split) {
        super(split);
    }

    protected void executeDataSnapshot(FetchTask.Context context) throws Exception {
        StoppableChangeEventSourceContext changeEventSourceContext;
        OracleSourceFetchTaskContext sourceFetchContext = (OracleSourceFetchTaskContext)context;
        OracleSnapshotSplitReadTask snapshotSplitReadTask = new OracleSnapshotSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getOffsetContext(), (SnapshotProgressListener<OraclePartition>)sourceFetchContext.getSnapshotChangeEventSourceMetrics(), sourceFetchContext.getDatabaseSchema(), sourceFetchContext.getConnection(), sourceFetchContext.getDispatcher(), this.snapshotSplit);
        SnapshotResult<OracleOffsetContext> snapshotResult = snapshotSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)(changeEventSourceContext = new StoppableChangeEventSourceContext()), sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
        if (!snapshotResult.isCompletedOrSkipped()) {
            this.taskRunning = false;
            throw new IllegalStateException(String.format("Read snapshot for oracle split %s fail", this.snapshotSplit));
        }
    }

    protected void executeBackfillTask(FetchTask.Context context, StreamSplit backfillStreamSplit) throws Exception {
        OracleSourceFetchTaskContext sourceFetchContext = (OracleSourceFetchTaskContext)context;
        OracleStreamFetchTask.RedoLogSplitReadTask backfillRedoLogReadTask = this.createBackfillRedoLogReadTask(backfillStreamSplit, sourceFetchContext);
        LogMinerOracleOffsetContextLoader loader = new LogMinerOracleOffsetContextLoader(((OracleSourceFetchTaskContext)context).getDbzConnectorConfig());
        OracleOffsetContext oracleOffsetContext = loader.load(backfillStreamSplit.getStartingOffset().getOffset());
        backfillRedoLogReadTask.execute((ChangeEventSource.ChangeEventSourceContext)new StoppableChangeEventSourceContext(), sourceFetchContext.getPartition(), oracleOffsetContext);
    }

    private OracleStreamFetchTask.RedoLogSplitReadTask createBackfillRedoLogReadTask(StreamSplit backfillRedoLogSplit, OracleSourceFetchTaskContext context) {
        Configuration dezConf = ((Configuration.Builder)context.getSourceConfig().getDbzConfiguration().edit().with("table.include.list", String.format("%s.%s", this.snapshotSplit.getTableId().schema(), this.snapshotSplit.getTableId().table())).with(Heartbeat.HEARTBEAT_INTERVAL, 0)).build();
        return new OracleStreamFetchTask.RedoLogSplitReadTask(new OracleConnectorConfig(dezConf), context.getConnection(), context.getDispatcher(), context.getErrorHandler(), context.getDatabaseSchema(), context.getSourceConfig().getOriginDbzConnectorConfig(), context.getStreamingChangeEventSourceMetrics(), backfillRedoLogSplit);
    }

    public static class OracleSnapshotSplitReadTask
    extends AbstractSnapshotChangeEventSource<OraclePartition, OracleOffsetContext> {
        private static final Logger LOG = LoggerFactory.getLogger(OracleSnapshotSplitReadTask.class);
        private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
        private final OracleConnectorConfig connectorConfig;
        private final OracleDatabaseSchema databaseSchema;
        private final OracleConnection jdbcConnection;
        private final JdbcSourceEventDispatcher<OraclePartition> dispatcher;
        private final Clock clock;
        private final SnapshotSplit snapshotSplit;
        private final OracleOffsetContext offsetContext;
        private final SnapshotProgressListener<OraclePartition> snapshotProgressListener;

        public OracleSnapshotSplitReadTask(OracleConnectorConfig connectorConfig, OracleOffsetContext previousOffset, SnapshotProgressListener<OraclePartition> snapshotProgressListener, OracleDatabaseSchema databaseSchema, OracleConnection jdbcConnection, JdbcSourceEventDispatcher<OraclePartition> dispatcher, SnapshotSplit snapshotSplit) {
            super((CommonConnectorConfig)connectorConfig, snapshotProgressListener);
            this.offsetContext = previousOffset;
            this.connectorConfig = connectorConfig;
            this.databaseSchema = databaseSchema;
            this.jdbcConnection = jdbcConnection;
            this.dispatcher = dispatcher;
            this.clock = Clock.SYSTEM;
            this.snapshotSplit = snapshotSplit;
            this.snapshotProgressListener = snapshotProgressListener;
        }

        public SnapshotResult<OracleOffsetContext> execute(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext previousOffset) throws InterruptedException {
            AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext> ctx;
            AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(partition, previousOffset);
            try {
                ctx = this.prepare(partition);
            }
            catch (Exception e) {
                LOG.error("Failed to initialize snapshot context.", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return this.doExecute(context, previousOffset, ctx, snapshottingTask);
            }
            catch (InterruptedException e) {
                LOG.warn("Snapshot was interrupted before completion");
                throw e;
            }
            catch (Exception t) {
                throw new DebeziumException((Throwable)t);
            }
        }

        protected SnapshotResult<OracleOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
            OracleSnapshotContext ctx = (OracleSnapshotContext)snapshotContext;
            ctx.offset = this.offsetContext;
            this.createDataEvents(ctx, this.snapshotSplit.getTableId());
            return SnapshotResult.completed((OffsetContext)ctx.offset);
        }

        protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(OraclePartition partition, OracleOffsetContext previousOffset) {
            return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
        }

        protected AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext> prepare(OraclePartition partition) throws Exception {
            return new OracleSnapshotContext(partition);
        }

        private void createDataEvents(OracleSnapshotContext snapshotContext, TableId tableId) throws Exception {
            EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
            LOG.debug("Snapshotting table {}", (Object)tableId);
            this.createDataEventsForTable(snapshotContext, (EventDispatcher.SnapshotReceiver<OraclePartition>)snapshotReceiver, this.databaseSchema.tableFor(tableId));
            snapshotReceiver.completeSnapshot();
        }

        private void createDataEventsForTable(OracleSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<OraclePartition> snapshotReceiver, Table table) throws InterruptedException {
            long exportStart = this.clock.currentTimeInMillis();
            LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
            String selectSql = OracleUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
            LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
            try (PreparedStatement selectStatement = OracleUtils.readTableSplitDataStatement((JdbcConnection)this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, this.snapshotSplit.getSplitStart(), this.snapshotSplit.getSplitEnd(), this.snapshotSplit.getSplitKeyType().getFieldCount(), this.connectorConfig.getQueryFetchSize());
                 ResultSet rs = selectStatement.executeQuery();){
                ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray((ResultSet)rs, (Table)table);
                long rows = 0L;
                Threads.Timer logTimer = this.getTableScanLogTimer();
                while (rs.next()) {
                    ++rows;
                    Object[] row = this.jdbcConnection.rowToArray(table, (DatabaseSchema)this.databaseSchema, rs, columnArray);
                    if (logTimer.expired()) {
                        long stop = this.clock.currentTimeInMillis();
                        LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration((long)(stop - exportStart))});
                        this.snapshotProgressListener.rowsScanned(snapshotContext.partition, table.id(), rows);
                        logTimer = this.getTableScanLogTimer();
                    }
                    this.dispatcher.dispatchSnapshotEvent(snapshotContext.partition, (DataCollectionId)table.id(), this.getChangeRecordEmitter((AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext>)snapshotContext, table.id(), row), snapshotReceiver);
                }
                LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
            }
            catch (SQLException e) {
                throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
            }
        }

        protected ChangeRecordEmitter<OraclePartition> getChangeRecordEmitter(AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, TableId tableId, Object[] row) {
            ((OracleOffsetContext)snapshotContext.offset).event((DataCollectionId)tableId, this.clock.currentTime());
            return new SnapshotChangeRecordEmitter(snapshotContext.partition, snapshotContext.offset, row, this.clock);
        }

        private Threads.Timer getTableScanLogTimer() {
            return Threads.timer((Clock)this.clock, (Duration)LOG_INTERVAL);
        }

        private static class OracleSnapshotContext
        extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> {
            public OracleSnapshotContext(OraclePartition partition) throws SQLException {
                super((Partition)partition, "");
            }
        }
    }
}

