/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle.source;

import java.time.Duration;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfigFactory;
import org.apache.flink.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.oracle.source.OracleDialect;
import org.apache.flink.cdc.connectors.oracle.source.config.OracleSourceConfigFactory;
import org.apache.flink.cdc.connectors.oracle.source.meta.offset.RedoLogOffsetFactory;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.util.Preconditions;

@Internal
public class OracleSourceBuilder<T> {
    private final OracleSourceConfigFactory configFactory = new OracleSourceConfigFactory();
    private RedoLogOffsetFactory offsetFactory;
    private OracleDialect dialect;
    private DebeziumDeserializationSchema<T> deserializer;

    public OracleSourceBuilder<T> hostname(String hostname) {
        this.configFactory.hostname(hostname);
        return this;
    }

    public OracleSourceBuilder<T> url(@Nullable String url) {
        this.configFactory.url(url);
        return this;
    }

    public OracleSourceBuilder<T> port(int port) {
        this.configFactory.port(port);
        return this;
    }

    public OracleSourceBuilder<T> databaseList(String ... databaseList) {
        this.configFactory.databaseList(databaseList);
        return this;
    }

    public OracleSourceBuilder<T> schemaList(String ... schemaList) {
        this.configFactory.schemaList(schemaList);
        return this;
    }

    public OracleSourceBuilder<T> tableList(String ... tableList) {
        this.configFactory.tableList(tableList);
        return this;
    }

    public OracleSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public OracleSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public OracleSourceBuilder<T> serverTimeZone(String timeZone) {
        this.configFactory.serverTimeZone(timeZone);
        return this;
    }

    public OracleSourceBuilder<T> splitSize(int splitSize) {
        this.configFactory.splitSize(splitSize);
        return this;
    }

    public OracleSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public OracleSourceBuilder<T> distributionFactorUpper(double distributionFactorUpper) {
        this.configFactory.distributionFactorUpper(distributionFactorUpper);
        return this;
    }

    public OracleSourceBuilder<T> distributionFactorLower(double distributionFactorLower) {
        this.configFactory.distributionFactorLower(distributionFactorLower);
        return this;
    }

    public OracleSourceBuilder<T> fetchSize(int fetchSize) {
        this.configFactory.fetchSize(fetchSize);
        return this;
    }

    public OracleSourceBuilder<T> connectTimeout(Duration connectTimeout) {
        this.configFactory.connectTimeout(connectTimeout);
        return this;
    }

    public OracleSourceBuilder<T> connectMaxRetries(int connectMaxRetries) {
        this.configFactory.connectMaxRetries(connectMaxRetries);
        return this;
    }

    public OracleSourceBuilder<T> connectionPoolSize(int connectionPoolSize) {
        this.configFactory.connectionPoolSize(connectionPoolSize);
        return this;
    }

    public OracleSourceBuilder<T> includeSchemaChanges(boolean includeSchemaChanges) {
        this.configFactory.includeSchemaChanges(includeSchemaChanges);
        return this;
    }

    public OracleSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public OracleSourceBuilder<T> chunkKeyColumn(String chunkKeyColumn) {
        this.configFactory.chunkKeyColumn(chunkKeyColumn);
        return this;
    }

    public OracleSourceBuilder<T> debeziumProperties(Properties properties) {
        this.configFactory.debeziumProperties(properties);
        return this;
    }

    public OracleSourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public OracleSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public OracleSourceBuilder<T> skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.configFactory.skipSnapshotBackfill(skipSnapshotBackfill);
        return this;
    }

    public OracleIncrementalSource<T> build() {
        this.offsetFactory = new RedoLogOffsetFactory();
        this.dialect = new OracleDialect();
        return new OracleIncrementalSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer), this.offsetFactory, this.dialect);
    }

    public static class OracleIncrementalSource<T>
    extends JdbcIncrementalSource<T> {
        public OracleIncrementalSource(OracleSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, RedoLogOffsetFactory offsetFactory, OracleDialect dataSourceDialect) {
            super((JdbcSourceConfigFactory)configFactory, deserializationSchema, (OffsetFactory)offsetFactory, (JdbcDataSourceDialect)dataSourceDialect);
        }

        public static <T> OracleSourceBuilder<T> builder() {
            return new OracleSourceBuilder();
        }
    }
}

