/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle.source;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.flink.cdc.connectors.oracle.source.config.OracleSourceConfig;

public class OraclePooledDataSourceFactory
extends JdbcConnectionPoolFactory {
    public static final String JDBC_URL_PATTERN = "jdbc:oracle:thin:@%s:%s:%s";

    public String getJdbcUrl(JdbcSourceConfig sourceConfig) {
        OracleSourceConfig oracleSourceConfig = (OracleSourceConfig)sourceConfig;
        if (StringUtils.isNotBlank((CharSequence)oracleSourceConfig.getUrl())) {
            return oracleSourceConfig.getUrl();
        }
        String hostName = sourceConfig.getHostname();
        int port = sourceConfig.getPort();
        String database = (String)sourceConfig.getDatabaseList().get(0);
        return String.format(JDBC_URL_PATTERN, hostName, port, database);
    }
}

