/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle.source;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import org.apache.flink.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.flink.cdc.connectors.base.source.assigner.splitter.ChunkSplitter;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.oracle.source.OraclePooledDataSourceFactory;
import org.apache.flink.cdc.connectors.oracle.source.assigner.splitter.OracleChunkSplitter;
import org.apache.flink.cdc.connectors.oracle.source.config.OracleSourceConfig;
import org.apache.flink.cdc.connectors.oracle.source.meta.offset.RedoLogOffset;
import org.apache.flink.cdc.connectors.oracle.source.reader.fetch.OracleScanFetchTask;
import org.apache.flink.cdc.connectors.oracle.source.reader.fetch.OracleSourceFetchTaskContext;
import org.apache.flink.cdc.connectors.oracle.source.reader.fetch.OracleStreamFetchTask;
import org.apache.flink.cdc.connectors.oracle.source.utils.OracleConnectionUtils;
import org.apache.flink.cdc.connectors.oracle.source.utils.OracleSchema;
import org.apache.flink.util.FlinkRuntimeException;

@Experimental
public class OracleDialect
implements JdbcDataSourceDialect {
    private static final long serialVersionUID = 1L;
    private transient OracleSchema oracleSchema;
    private transient Tables.TableFilter filters;

    public String getName() {
        return "Oracle";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Offset displayCurrentOffset(JdbcSourceConfig sourceConfig) {
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            RedoLogOffset redoLogOffset = OracleConnectionUtils.currentRedoLogOffset(jdbcConnection);
            return redoLogOffset;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Read the redoLog offset error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDataCollectionIdCaseSensitive(JdbcSourceConfig sourceConfig) {
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            OracleConnection oracleConnection = (OracleConnection)jdbcConnection;
            boolean bl = oracleConnection.getOracleVersion().getMajor() == 11;
            return bl;
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error reading oracle variables: " + e.getMessage(), (Throwable)e);
        }
    }

    public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        return OracleConnectionUtils.createOracleConnection(sourceConfig.getDbzConnectorConfig().getJdbcConfig());
    }

    public ChunkSplitter createChunkSplitter(JdbcSourceConfig sourceConfig) {
        return new OracleChunkSplitter(sourceConfig, this);
    }

    public JdbcConnectionPoolFactory getPooledDataSourceFactory() {
        return new OraclePooledDataSourceFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TableId> discoverDataCollections(JdbcSourceConfig sourceConfig) {
        OracleSourceConfig oracleSourceConfig = (OracleSourceConfig)sourceConfig;
        try (JdbcConnection jdbcConnection = this.openJdbcConnection(sourceConfig);){
            List<TableId> list = OracleConnectionUtils.listTables(jdbcConnection, oracleSourceConfig.getTableFilters());
            return list;
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error to discover tables: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<TableId, TableChanges.TableChange> discoverDataCollectionSchemas(JdbcSourceConfig sourceConfig) {
        List<TableId> capturedTableIds = this.discoverDataCollections(sourceConfig);
        try (OracleConnection jdbc = OracleConnectionUtils.createOracleConnection(sourceConfig.getDbzConfiguration());){
            HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
            for (TableId tableId : capturedTableIds) {
                TableChanges.TableChange tableSchema = this.queryTableSchema((JdbcConnection)jdbc, tableId);
                tableSchemas.put(tableId, tableSchema);
            }
            HashMap<TableId, TableChanges.TableChange> hashMap = tableSchemas;
            return hashMap;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error to discover table schemas: " + e.getMessage(), (Throwable)e);
        }
    }

    public TableChanges.TableChange queryTableSchema(JdbcConnection jdbc, TableId tableId) {
        if (this.oracleSchema == null) {
            this.oracleSchema = new OracleSchema();
        }
        return this.oracleSchema.getTableSchema(jdbc, tableId);
    }

    public OracleSourceFetchTaskContext createFetchTaskContext(JdbcSourceConfig taskSourceConfig) {
        return new OracleSourceFetchTaskContext(taskSourceConfig, this);
    }

    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase sourceSplitBase) {
        if (sourceSplitBase.isSnapshotSplit()) {
            return new OracleScanFetchTask(sourceSplitBase.asSnapshotSplit());
        }
        return new OracleStreamFetchTask(sourceSplitBase.asStreamSplit());
    }

    public boolean isIncludeDataCollection(JdbcSourceConfig sourceConfig, TableId tableId) {
        if (this.filters == null) {
            this.filters = sourceConfig.getTableFilters().dataCollectionFilter();
        }
        return this.filters.isIncluded(tableId);
    }
}

