/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.OracleDriver;
import org.apache.flink.cdc.connectors.oracle.util.OracleJdbcUrlUtils;
import org.apache.flink.cdc.debezium.Validator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;

public class OracleValidator
implements Validator {
    private static final long serialVersionUID = 1L;
    private final Properties properties;
    private static final List<Integer> SUPPORT_VERSIONS = Arrays.asList(11, 12, 19, 21);

    public OracleValidator(Properties properties) {
        this.properties = properties;
    }

    public void validate() {
        try (Connection connection = OracleValidator.openConnection(this.properties);){
            DatabaseMetaData metaData = connection.getMetaData();
            if (!SUPPORT_VERSIONS.contains(metaData.getDatabaseMajorVersion())) {
                throw new ValidationException(String.format("Currently Flink Oracle CDC connector only supports Oracle whose version is either %s but actual is %d.%d.", SUPPORT_VERSIONS, metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion()));
            }
        }
        catch (SQLException ex) {
            throw new TableException("Unexpected error while connecting to Oracle and validating", (Throwable)ex);
        }
    }

    public static Connection openConnection(Properties properties) throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        String url = OracleJdbcUrlUtils.getConnectionUrlWithSid(properties);
        String userName = properties.getProperty("database.user");
        String userpwd = properties.getProperty("database.password");
        return DriverManager.getConnection(url, userName, userpwd);
    }
}

