/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oracle;

import io.debezium.connector.oracle.OracleConnector;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.oracle.OracleValidator;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.cdc.debezium.Validator;
import org.apache.flink.util.Preconditions;

public class OracleSource {
    private static final String DATABASE_SERVER_NAME = "oracle_logminer";

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private Integer port = 1521;
        private String hostname;
        private String database;
        private String username;
        private String password;
        private String url;
        private String[] tableList;
        private String[] schemaList;
        private Properties dbzProperties;
        private StartupOptions startupOptions = StartupOptions.initial();
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public Builder<T> url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public Builder<T> database(String database) {
            this.database = database;
            return this;
        }

        public Builder<T> tableList(String ... tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> schemaList(String ... schemaList) {
            this.schemaList = schemaList;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> debeziumProperties(Properties properties) {
            this.dbzProperties = properties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> startupOptions(StartupOptions startupOptions) {
            this.startupOptions = startupOptions;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", OracleConnector.class.getCanonicalName());
            props.setProperty("database.server.name", OracleSource.DATABASE_SERVER_NAME);
            props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
            props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
            if (this.url != null) {
                props.setProperty("database.url", this.url);
            }
            if (this.hostname != null) {
                props.setProperty("database.hostname", this.hostname);
            }
            if (this.port != null) {
                props.setProperty("database.port", String.valueOf(this.port));
            }
            props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
            props.setProperty("database.dbname", (String)Preconditions.checkNotNull((Object)this.database));
            if (this.schemaList != null) {
                props.setProperty("schema.include.list", String.join((CharSequence)",", this.schemaList));
            }
            if (this.tableList != null) {
                props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
            }
            props.setProperty("internal.log.mining.transaction.snapshot.boundary.mode", "all");
            switch (this.startupOptions.startupMode) {
                case INITIAL: {
                    props.setProperty("snapshot.mode", "initial");
                    break;
                }
                case LATEST_OFFSET: {
                    props.setProperty("snapshot.mode", "schema_only");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.dbzProperties != null) {
                props.putAll((Map<?, ?>)this.dbzProperties);
            }
            if (this.url == null) {
                Preconditions.checkNotNull((Object)this.hostname, (String)"hostname is required when url is not configured");
                props.setProperty("database.hostname", this.hostname);
                Preconditions.checkNotNull((Object)this.port, (String)"port is required when url is not configured");
                props.setProperty("database.port", String.valueOf(this.port));
            }
            return new DebeziumSourceFunction(this.deserializer, props, null, (Validator)new OracleValidator(props));
        }
    }
}

