/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import java.util.Optional;
import oracle.sql.ROWID;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.header.ConnectHeaders;

public class LogMinerChangeRecordEmitter
extends BaseChangeRecordEmitter<Object> {
    private final Envelope.Operation operation;
    private final String rowId;

    public LogMinerChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, Envelope.Operation operation, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock, String rowId) {
        super(connectorConfig, partition, offset, schema, table, clock, oldValues, newValues);
        this.operation = operation;
        this.rowId = rowId;
    }

    public LogMinerChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, EventType eventType, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock, String rowId) {
        this(connectorConfig, partition, offset, LogMinerChangeRecordEmitter.getOperation(eventType), oldValues, newValues, table, schema, clock, rowId);
    }

    private static Envelope.Operation getOperation(EventType eventType) {
        switch (eventType) {
            case INSERT: {
                return Envelope.Operation.CREATE;
            }
            case UPDATE: 
            case SELECT_LOB_LOCATOR: {
                return Envelope.Operation.UPDATE;
            }
            case DELETE: {
                return Envelope.Operation.DELETE;
            }
        }
        throw new DebeziumException("Unsupported operation type: " + eventType);
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    protected Optional<ConnectHeaders> getEmitConnectHeaders() {
        ConnectHeaders headers = new ConnectHeaders();
        headers.add(ROWID.class.getSimpleName(), new SchemaAndValue(null, (Object)this.rowId));
        return Optional.of(headers);
    }
}

