/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.util.TableConnectorUtil;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class KafkaTableSinkBase
implements AppendStreamTableSink<Row> {
    private final Optional<TableSchema> schema;
    protected final String topic;
    protected final Properties properties;
    protected Optional<SerializationSchema<Row>> serializationSchema;
    protected final Optional<FlinkKafkaPartitioner<Row>> partitioner;
    protected String[] fieldNames;
    protected TypeInformation[] fieldTypes;

    protected KafkaTableSinkBase(TableSchema schema, String topic, Properties properties, Optional<FlinkKafkaPartitioner<Row>> partitioner, SerializationSchema<Row> serializationSchema) {
        this.schema = Optional.of(Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null."));
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.partitioner = (Optional)Preconditions.checkNotNull(partitioner, (String)"Partitioner must not be null.");
        this.serializationSchema = Optional.of(Preconditions.checkNotNull(serializationSchema, (String)"Serialization schema must not be null."));
    }

    @Deprecated
    public KafkaTableSinkBase(String topic, Properties properties, FlinkKafkaPartitioner<Row> partitioner) {
        this.schema = Optional.empty();
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"topic");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"properties");
        this.partitioner = Optional.of(Preconditions.checkNotNull(partitioner, (String)"partitioner"));
        this.serializationSchema = Optional.empty();
    }

    protected abstract SinkFunction<Row> createKafkaProducer(String var1, Properties var2, SerializationSchema<Row> var3, Optional<FlinkKafkaPartitioner<Row>> var4);

    @Deprecated
    protected SerializationSchema<Row> createSerializationSchema(RowTypeInfo rowSchema) {
        throw new UnsupportedOperationException("This method only exists for backwards compatibility.");
    }

    @Deprecated
    protected KafkaTableSinkBase createCopy() {
        throw new UnsupportedOperationException("This method only exists for backwards compatibility.");
    }

    public void emitDataStream(DataStream<Row> dataStream) {
        SinkFunction<Row> kafkaProducer = this.createKafkaProducer(this.topic, this.properties, this.serializationSchema.orElseThrow(() -> new IllegalStateException("No serialization schema defined.")), this.partitioner);
        dataStream.addSink(kafkaProducer).name(TableConnectorUtil.generateRuntimeName(this.getClass(), (String[])this.fieldNames));
    }

    public TypeInformation<Row> getOutputType() {
        return this.schema.map(TableSchema::toRowType).orElseGet(() -> new RowTypeInfo(this.getFieldTypes()));
    }

    public String[] getFieldNames() {
        return this.schema.map(TableSchema::getFieldNames).orElse(this.fieldNames);
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.schema.map(TableSchema::getFieldTypes).orElse(this.fieldTypes);
    }

    public KafkaTableSinkBase configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (this.schema.isPresent()) {
            throw new UnsupportedOperationException("Reconfiguration of this sink is not supported.");
        }
        KafkaTableSinkBase copy = this.createCopy();
        copy.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames, (String)"fieldNames");
        copy.fieldTypes = (TypeInformation[])Preconditions.checkNotNull(fieldTypes, (String)"fieldTypes");
        Preconditions.checkArgument((fieldNames.length == fieldTypes.length ? 1 : 0) != 0, (Object)"Number of provided field names and types does not match.");
        RowTypeInfo rowSchema = new RowTypeInfo(fieldTypes, fieldNames);
        copy.serializationSchema = Optional.of(this.createSerializationSchema(rowSchema));
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTableSinkBase that = (KafkaTableSinkBase)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.topic, that.topic) && Objects.equals(this.properties, that.properties) && Objects.equals(this.serializationSchema, that.serializationSchema) && Objects.equals(this.partitioner, that.partitioner) && Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.fieldTypes, that.fieldTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.schema, this.topic, this.properties, this.serializationSchema, this.partitioner);
        result = 31 * result + Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode(this.fieldTypes);
        return result;
    }
}

