/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;

public class FloatDeserializer
implements Deserializer<Float> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Float deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 4) {
            throw new SerializationException("Size of data received by Deserializer is not 4");
        }
        int value = 0;
        for (byte b : data) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(value));
    }

    @Override
    public void close() {
    }
}

