/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.scram.internals;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.scram.ScramExtensionsCallback;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.scram.internals.ScramMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScramSaslClient
implements SaslClient {
    private static final Logger log = LoggerFactory.getLogger(ScramSaslClient.class);
    private final ScramMechanism mechanism;
    private final CallbackHandler callbackHandler;
    private final ScramFormatter formatter;
    private String clientNonce;
    private State state;
    private byte[] saltedPassword;
    private ScramMessages.ClientFirstMessage clientFirstMessage;
    private ScramMessages.ServerFirstMessage serverFirstMessage;
    private ScramMessages.ClientFinalMessage clientFinalMessage;

    public ScramSaslClient(ScramMechanism mechanism, CallbackHandler cbh) throws NoSuchAlgorithmException {
        this.mechanism = mechanism;
        this.callbackHandler = cbh;
        this.formatter = new ScramFormatter(mechanism);
        this.setState(State.SEND_CLIENT_FIRST_MESSAGE);
    }

    @Override
    public String getMechanismName() {
        return this.mechanism.mechanismName();
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        try {
            switch (this.state) {
                case SEND_CLIENT_FIRST_MESSAGE: {
                    if (challenge != null && challenge.length != 0) {
                        throw new SaslException("Expected empty challenge");
                    }
                    this.clientNonce = this.formatter.secureRandomString();
                    NameCallback nameCallback = new NameCallback("Name:");
                    ScramExtensionsCallback extensionsCallback = new ScramExtensionsCallback();
                    try {
                        this.callbackHandler.handle(new Callback[]{nameCallback});
                        try {
                            this.callbackHandler.handle(new Callback[]{extensionsCallback});
                        }
                        catch (UnsupportedCallbackException e) {
                            log.debug("Extensions callback is not supported by client callback handler {}, no extensions will be added", (Object)this.callbackHandler);
                        }
                    }
                    catch (Throwable e) {
                        throw new SaslException("User name or extensions could not be obtained", e);
                    }
                    String username = nameCallback.getName();
                    String saslName = this.formatter.saslName(username);
                    Map<String, String> extensions = extensionsCallback.extensions();
                    this.clientFirstMessage = new ScramMessages.ClientFirstMessage(saslName, this.clientNonce, extensions);
                    this.setState(State.RECEIVE_SERVER_FIRST_MESSAGE);
                    return this.clientFirstMessage.toBytes();
                }
                case RECEIVE_SERVER_FIRST_MESSAGE: {
                    this.serverFirstMessage = new ScramMessages.ServerFirstMessage(challenge);
                    if (!this.serverFirstMessage.nonce().startsWith(this.clientNonce)) {
                        throw new SaslException("Invalid server nonce: does not start with client nonce");
                    }
                    if (this.serverFirstMessage.iterations() < this.mechanism.minIterations()) {
                        throw new SaslException("Requested iterations " + this.serverFirstMessage.iterations() + " is less than the minimum " + this.mechanism.minIterations() + " for " + (Object)((Object)this.mechanism));
                    }
                    PasswordCallback passwordCallback = new PasswordCallback("Password:", false);
                    try {
                        this.callbackHandler.handle(new Callback[]{passwordCallback});
                    }
                    catch (Throwable e) {
                        throw new SaslException("User name could not be obtained", e);
                    }
                    this.clientFinalMessage = this.handleServerFirstMessage(passwordCallback.getPassword());
                    this.setState(State.RECEIVE_SERVER_FINAL_MESSAGE);
                    return this.clientFinalMessage.toBytes();
                }
                case RECEIVE_SERVER_FINAL_MESSAGE: {
                    ScramMessages.ServerFinalMessage serverFinalMessage = new ScramMessages.ServerFinalMessage(challenge);
                    if (serverFinalMessage.error() != null) {
                        throw new SaslException("Sasl authentication using " + (Object)((Object)this.mechanism) + " failed with error: " + serverFinalMessage.error());
                    }
                    this.handleServerFinalMessage(serverFinalMessage.serverSignature());
                    this.setState(State.COMPLETE);
                    return null;
                }
            }
            throw new IllegalSaslStateException("Unexpected challenge in Sasl client state " + (Object)((Object)this.state));
        }
        catch (SaslException e) {
            this.setState(State.FAILED);
            throw e;
        }
    }

    @Override
    public boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    private void setState(State state) {
        log.debug("Setting SASL/{} client state to {}", (Object)this.mechanism, (Object)state);
        this.state = state;
    }

    private ScramMessages.ClientFinalMessage handleServerFirstMessage(char[] password) throws SaslException {
        try {
            byte[] passwordBytes = this.formatter.normalize(new String(password));
            this.saltedPassword = this.formatter.hi(passwordBytes, this.serverFirstMessage.salt(), this.serverFirstMessage.iterations());
            ScramMessages.ClientFinalMessage clientFinalMessage = new ScramMessages.ClientFinalMessage("n,,".getBytes(StandardCharsets.UTF_8), this.serverFirstMessage.nonce());
            byte[] clientProof = this.formatter.clientProof(this.saltedPassword, this.clientFirstMessage, this.serverFirstMessage, clientFinalMessage);
            clientFinalMessage.proof(clientProof);
            return clientFinalMessage;
        }
        catch (InvalidKeyException e) {
            throw new SaslException("Client final message could not be created", e);
        }
    }

    private void handleServerFinalMessage(byte[] signature) throws SaslException {
        try {
            byte[] serverKey = this.formatter.serverKey(this.saltedPassword);
            byte[] serverSignature = this.formatter.serverSignature(serverKey, this.clientFirstMessage, this.serverFirstMessage, this.clientFinalMessage);
            if (!Arrays.equals(signature, serverSignature)) {
                throw new SaslException("Invalid server signature in server final message");
            }
        }
        catch (InvalidKeyException e) {
            throw new SaslException("Sasl server signature verification failed", e);
        }
    }

    public static class ScramSaslClientFactory
    implements SaslClientFactory {
        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            String mech;
            ScramMechanism mechanism = null;
            String[] stringArray = mechanisms;
            int n = stringArray.length;
            for (int i = 0; i < n && (mechanism = ScramMechanism.forMechanismName(mech = stringArray[i])) == null; ++i) {
            }
            if (mechanism == null) {
                throw new SaslException(String.format("Requested mechanisms '%s' not supported. Supported mechanisms are '%s'.", Arrays.asList(mechanisms), ScramMechanism.mechanismNames()));
            }
            try {
                return new ScramSaslClient(mechanism, cbh);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Hash algorithm not supported for mechanism " + (Object)((Object)mechanism), e);
            }
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            Collection<String> mechanisms = ScramMechanism.mechanismNames();
            return mechanisms.toArray(new String[mechanisms.size()]);
        }
    }

    static enum State {
        SEND_CLIENT_FIRST_MESSAGE,
        RECEIVE_SERVER_FIRST_MESSAGE,
        RECEIVE_SERVER_FINAL_MESSAGE,
        COMPLETE,
        FAILED;

    }
}

