/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerSaslClient
implements SaslClient {
    static final byte BYTE_CONTROL_A = 1;
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerSaslClient.class);
    private final CallbackHandler callbackHandler;
    private State state;

    public OAuthBearerSaslClient(AuthenticateCallbackHandler callbackHandler) {
        this.callbackHandler = Objects.requireNonNull(callbackHandler);
        this.setState(State.SEND_CLIENT_FIRST_MESSAGE);
    }

    public CallbackHandler callbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "OAUTHBEARER";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        try {
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            switch (this.state) {
                case SEND_CLIENT_FIRST_MESSAGE: {
                    if (challenge != null && challenge.length != 0) {
                        throw new SaslException("Expected empty challenge");
                    }
                    this.callbackHandler().handle(new Callback[]{callback});
                    this.setState(State.RECEIVE_SERVER_FIRST_MESSAGE);
                    return new OAuthBearerClientInitialResponse(callback.token().value()).toBytes();
                }
                case RECEIVE_SERVER_FIRST_MESSAGE: {
                    if (challenge != null && challenge.length != 0) {
                        String jsonErrorResponse = new String(challenge, StandardCharsets.UTF_8);
                        if (log.isDebugEnabled()) {
                            log.debug("Sending %%x01 response to server after receiving an error: {}", (Object)jsonErrorResponse);
                        }
                        this.setState(State.RECEIVE_SERVER_MESSAGE_AFTER_FAILURE);
                        return new byte[]{1};
                    }
                    this.callbackHandler().handle(new Callback[]{callback});
                    if (log.isDebugEnabled()) {
                        log.debug("Successfully authenticated as {}", (Object)callback.token().principalName());
                    }
                    this.setState(State.COMPLETE);
                    return null;
                }
            }
            throw new IllegalSaslStateException("Unexpected challenge in Sasl client state " + (Object)((Object)this.state));
        }
        catch (SaslException e) {
            this.setState(State.FAILED);
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            this.setState(State.FAILED);
            throw new SaslException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    private void setState(State state) {
        log.debug("Setting SASL/{} client state to {}", (Object)"OAUTHBEARER", (Object)state);
        this.state = state;
    }

    public static class OAuthBearerSaslClientFactory
    implements SaslClientFactory {
        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
            String[] mechanismNamesCompatibleWithPolicy = this.getMechanismNames(props);
            for (String mechanism : mechanisms) {
                for (int i = 0; i < mechanismNamesCompatibleWithPolicy.length; ++i) {
                    if (!mechanismNamesCompatibleWithPolicy[i].equals(mechanism)) continue;
                    if (!(Objects.requireNonNull(callbackHandler) instanceof AuthenticateCallbackHandler)) {
                        throw new IllegalArgumentException(String.format("Callback handler must be castable to %s: %s", AuthenticateCallbackHandler.class.getName(), callbackHandler.getClass().getName()));
                    }
                    return new OAuthBearerSaslClient((AuthenticateCallbackHandler)callbackHandler);
                }
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return OAuthBearerSaslServer.mechanismNamesCompatibleWithPolicy(props);
        }
    }

    static enum State {
        SEND_CLIENT_FIRST_MESSAGE,
        RECEIVE_SERVER_FIRST_MESSAGE,
        RECEIVE_SERVER_MESSAGE_AFTER_FAILURE,
        COMPLETE,
        FAILED;

    }
}

