/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.sasl.SaslException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class OAuthBearerClientInitialResponse {
    static final String SEPARATOR = "\u0001";
    private static final String SASLNAME = "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+";
    private static final String KEY = "[A-Za-z]+";
    private static final String VALUE = "[\\x21-\\x7E \t\r\n]+";
    private static final String KVPAIRS = String.format("(%s=%s%s)*", "[A-Za-z]+", "[\\x21-\\x7E \t\r\n]+", "\u0001");
    private static final Pattern AUTH_PATTERN = Pattern.compile("(?<scheme>[\\w]+)[ ]+(?<token>[-_\\.a-zA-Z0-9]+)");
    private static final Pattern CLIENT_INITIAL_RESPONSE_PATTERN = Pattern.compile(String.format("n,(a=(?<authzid>%s))?,%s(?<kvpairs>%s)%s", "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+", "\u0001", KVPAIRS, "\u0001"));
    private static final String AUTH_KEY = "auth";
    private final String tokenValue;
    private final String authorizationId;
    private final Map<String, String> properties;

    public OAuthBearerClientInitialResponse(byte[] response) throws SaslException {
        String responseMsg = new String(response, StandardCharsets.UTF_8);
        Matcher matcher = CLIENT_INITIAL_RESPONSE_PATTERN.matcher(responseMsg);
        if (!matcher.matches()) {
            throw new SaslException("Invalid OAUTHBEARER client first message");
        }
        String authzid = matcher.group("authzid");
        this.authorizationId = authzid == null ? "" : authzid;
        String kvPairs = matcher.group("kvpairs");
        this.properties = Utils.parseMap(kvPairs, "=", SEPARATOR);
        String auth = this.properties.get(AUTH_KEY);
        if (auth == null) {
            throw new SaslException("Invalid OAUTHBEARER client first message: 'auth' not specified");
        }
        Matcher authMatcher = AUTH_PATTERN.matcher(auth);
        if (!authMatcher.matches()) {
            throw new SaslException("Invalid OAUTHBEARER client first message: invalid 'auth' format");
        }
        if (!"bearer".equalsIgnoreCase(authMatcher.group("scheme"))) {
            String msg = String.format("Invalid scheme in OAUTHBEARER client first message: %s", matcher.group("scheme"));
            throw new SaslException(msg);
        }
        this.tokenValue = authMatcher.group("token");
    }

    public OAuthBearerClientInitialResponse(String tokenValue) {
        this(tokenValue, "", new HashMap<String, String>());
    }

    public OAuthBearerClientInitialResponse(String tokenValue, String authorizationId, Map<String, String> props) {
        this.tokenValue = tokenValue;
        this.authorizationId = authorizationId == null ? "" : authorizationId;
        this.properties = new HashMap<String, String>(props);
    }

    public byte[] toBytes() {
        String authzid = this.authorizationId.isEmpty() ? "" : "a=" + this.authorizationId;
        String message = String.format("n,%s,%sauth=Bearer %s%s%s", authzid, SEPARATOR, this.tokenValue, SEPARATOR, SEPARATOR);
        return message.getBytes(StandardCharsets.UTF_8);
    }

    public String tokenValue() {
        return this.tokenValue;
    }

    public String authorizationId() {
        return this.authorizationId;
    }

    public String propertyValue(String name) {
        return this.properties.get(name);
    }
}

