/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final Schema OFFSET_COMMIT_RESPONSE_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE);
    private static final Schema OFFSET_COMMIT_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(OFFSET_COMMIT_RESPONSE_PARTITION_V0)));
    private static final Schema OFFSET_COMMIT_RESPONSE_V0;
    private static final Schema OFFSET_COMMIT_RESPONSE_V1;
    private static final Schema OFFSET_COMMIT_RESPONSE_V2;
    private static final Schema OFFSET_COMMIT_RESPONSE_V3;
    private static final Schema OFFSET_COMMIT_RESPONSE_V4;
    private final Map<TopicPartition, Errors> responseData;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_COMMIT_RESPONSE_V0, OFFSET_COMMIT_RESPONSE_V1, OFFSET_COMMIT_RESPONSE_V2, OFFSET_COMMIT_RESPONSE_V3, OFFSET_COMMIT_RESPONSE_V4};
    }

    public OffsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        this(0, responseData);
    }

    public OffsetCommitResponse(int throttleTimeMs, Map<TopicPartition, Errors> responseData) {
        this.throttleTimeMs = throttleTimeMs;
        this.responseData = responseData;
    }

    public OffsetCommitResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.responseData = new HashMap<TopicPartition, Errors>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionResponse.get(CommonFields.ERROR_CODE));
                this.responseData.put(new TopicPartition(topic, partition), error);
            }
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.OFFSET_COMMIT.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> topicsData = CollectionUtils.groupDataByTopic(this.responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Errors>> entries : topicsData.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Errors> partitionEntry : entries.getValue().entrySet()) {
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(CommonFields.ERROR_CODE, partitionEntry.getValue().code());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> responseData() {
        return this.responseData;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.responseData);
    }

    public static OffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new OffsetCommitResponse(ApiKeys.OFFSET_COMMIT.parseResponse(version, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    static {
        OFFSET_COMMIT_RESPONSE_V1 = OFFSET_COMMIT_RESPONSE_V0 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(OFFSET_COMMIT_RESPONSE_TOPIC_V0)));
        OFFSET_COMMIT_RESPONSE_V2 = OFFSET_COMMIT_RESPONSE_V0;
        OFFSET_COMMIT_RESPONSE_V4 = OFFSET_COMMIT_RESPONSE_V3 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(OFFSET_COMMIT_RESPONSE_TOPIC_V0)));
    }
}

