/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class InitProducerIdResponse
extends AbstractResponse {
    private static final Schema INIT_PRODUCER_ID_RESPONSE_V0;
    private static final Schema INIT_PRODUCER_ID_RESPONSE_V1;
    private final int throttleTimeMs;
    private final Errors error;
    private final long producerId;
    private final short epoch;

    public static Schema[] schemaVersions() {
        return new Schema[]{INIT_PRODUCER_ID_RESPONSE_V0, INIT_PRODUCER_ID_RESPONSE_V1};
    }

    public InitProducerIdResponse(int throttleTimeMs, Errors error, long producerId, short epoch) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.producerId = producerId;
        this.epoch = epoch;
    }

    public InitProducerIdResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.producerId = struct.get(CommonFields.PRODUCER_ID);
        this.epoch = struct.get(CommonFields.PRODUCER_EPOCH);
    }

    public InitProducerIdResponse(int throttleTimeMs, Errors errors) {
        this(throttleTimeMs, errors, -1L, 0);
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public long producerId() {
        return this.producerId;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public short epoch() {
        return this.epoch;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.INIT_PRODUCER_ID.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        struct.set(CommonFields.PRODUCER_ID, this.producerId);
        struct.set(CommonFields.PRODUCER_EPOCH, this.epoch);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        return struct;
    }

    public static InitProducerIdResponse parse(ByteBuffer buffer, short version) {
        return new InitProducerIdResponse(ApiKeys.INIT_PRODUCER_ID.parseResponse(version, buffer));
    }

    public String toString() {
        return "InitProducerIdResponse(error=" + (Object)((Object)this.error) + ", producerId=" + this.producerId + ", producerEpoch=" + this.epoch + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        INIT_PRODUCER_ID_RESPONSE_V1 = INIT_PRODUCER_ID_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, CommonFields.PRODUCER_ID, CommonFields.PRODUCER_EPOCH);
    }
}

