/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartitionInfo;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class TopicDescription {
    private final String name;
    private final boolean internal;
    private final List<TopicPartitionInfo> partitions;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicDescription that = (TopicDescription)o;
        if (this.internal != that.internal) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.partitions != null ? this.partitions.equals(that.partitions) : that.partitions == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.internal ? 1 : 0);
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        return result;
    }

    public TopicDescription(String name, boolean internal, List<TopicPartitionInfo> partitions) {
        this.name = name;
        this.internal = internal;
        this.partitions = partitions;
    }

    public String name() {
        return this.name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public List<TopicPartitionInfo> partitions() {
        return this.partitions;
    }

    public String toString() {
        return "(name=" + this.name + ", internal=" + this.internal + ", partitions=" + Utils.join(this.partitions, ",") + ")";
    }
}

