/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.ConnectionState;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.AuthenticationException;

final class ClusterConnectionStates {
    private final long reconnectBackoffInitMs;
    private final long reconnectBackoffMaxMs;
    private static final int RECONNECT_BACKOFF_EXP_BASE = 2;
    private final double reconnectBackoffMaxExp;
    private final Map<String, NodeConnectionState> nodeState;

    public ClusterConnectionStates(long reconnectBackoffMs, long reconnectBackoffMaxMs) {
        this.reconnectBackoffInitMs = reconnectBackoffMs;
        this.reconnectBackoffMaxMs = reconnectBackoffMaxMs;
        this.reconnectBackoffMaxExp = Math.log((double)this.reconnectBackoffMaxMs / (double)Math.max(reconnectBackoffMs, 1L)) / Math.log(2.0);
        this.nodeState = new HashMap<String, NodeConnectionState>();
    }

    public boolean canConnect(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return true;
        }
        return state.state.isDisconnected() && now - state.lastConnectAttemptMs >= state.reconnectBackoffMs;
    }

    public boolean isBlackedOut(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return false;
        }
        return state.state.isDisconnected() && now - state.lastConnectAttemptMs < state.reconnectBackoffMs;
    }

    public long connectionDelay(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return 0L;
        }
        long timeWaited = now - state.lastConnectAttemptMs;
        if (state.state.isDisconnected()) {
            return Math.max(state.reconnectBackoffMs - timeWaited, 0L);
        }
        return Long.MAX_VALUE;
    }

    public boolean isConnecting(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.CONNECTING;
    }

    public void connecting(String id, long now) {
        if (this.nodeState.containsKey(id)) {
            NodeConnectionState node = this.nodeState.get(id);
            node.lastConnectAttemptMs = now;
            node.state = ConnectionState.CONNECTING;
        } else {
            this.nodeState.put(id, new NodeConnectionState(ConnectionState.CONNECTING, now, this.reconnectBackoffInitMs));
        }
    }

    public void disconnected(String id, long now) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.DISCONNECTED;
        nodeState.lastConnectAttemptMs = now;
        this.updateReconnectBackoff(nodeState);
    }

    public void throttle(String id, long throttleUntilTimeMs) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state != null && state.throttleUntilTimeMs < throttleUntilTimeMs) {
            state.throttleUntilTimeMs = throttleUntilTimeMs;
        }
    }

    public long throttleDelayMs(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state != null && state.throttleUntilTimeMs > now) {
            return state.throttleUntilTimeMs - now;
        }
        return 0L;
    }

    public long pollDelayMs(String id, long now) {
        long throttleDelayMs = this.throttleDelayMs(id, now);
        if (this.isConnected(id) && throttleDelayMs > 0L) {
            return throttleDelayMs;
        }
        return this.connectionDelay(id, now);
    }

    public void checkingApiVersions(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.CHECKING_API_VERSIONS;
    }

    public void ready(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.READY;
        nodeState.authenticationException = null;
        this.resetReconnectBackoff(nodeState);
    }

    public void authenticationFailed(String id, long now, AuthenticationException exception) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.authenticationException = exception;
        nodeState.state = ConnectionState.AUTHENTICATION_FAILED;
        nodeState.lastConnectAttemptMs = now;
        this.updateReconnectBackoff(nodeState);
    }

    public boolean isReady(String id, long now) {
        return this.isReady(this.nodeState.get(id), now);
    }

    private boolean isReady(NodeConnectionState state, long now) {
        return state != null && state.state == ConnectionState.READY && state.throttleUntilTimeMs <= now;
    }

    public boolean hasReadyNodes(long now) {
        for (Map.Entry<String, NodeConnectionState> entry : this.nodeState.entrySet()) {
            if (!this.isReady(entry.getValue(), now)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state.isConnected();
    }

    public boolean isDisconnected(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state.isDisconnected();
    }

    public AuthenticationException authenticationException(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null ? state.authenticationException : null;
    }

    private void resetReconnectBackoff(NodeConnectionState nodeState) {
        nodeState.failedAttempts = 0L;
        nodeState.reconnectBackoffMs = this.reconnectBackoffInitMs;
    }

    private void updateReconnectBackoff(NodeConnectionState nodeState) {
        if (this.reconnectBackoffMaxMs > this.reconnectBackoffInitMs) {
            ++nodeState.failedAttempts;
            double backoffExp = Math.min((double)(nodeState.failedAttempts - 1L), this.reconnectBackoffMaxExp);
            double backoffFactor = Math.pow(2.0, backoffExp);
            long reconnectBackoffMs = (long)((double)this.reconnectBackoffInitMs * backoffFactor);
            double randomFactor = ThreadLocalRandom.current().nextDouble(0.8, 1.2);
            nodeState.reconnectBackoffMs = (long)(randomFactor * (double)reconnectBackoffMs);
        }
    }

    public void remove(String id) {
        this.nodeState.remove(id);
    }

    public ConnectionState connectionState(String id) {
        return this.nodeState((String)id).state;
    }

    private NodeConnectionState nodeState(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            throw new IllegalStateException("No entry found for connection " + id);
        }
        return state;
    }

    private static class NodeConnectionState {
        ConnectionState state;
        AuthenticationException authenticationException;
        long lastConnectAttemptMs;
        long failedAttempts;
        long reconnectBackoffMs;
        long throttleUntilTimeMs;

        public NodeConnectionState(ConnectionState state, long lastConnectAttempt, long reconnectBackoffMs) {
            this.state = state;
            this.authenticationException = null;
            this.lastConnectAttemptMs = lastConnectAttempt;
            this.failedAttempts = 0L;
            this.reconnectBackoffMs = reconnectBackoffMs;
            this.throttleUntilTimeMs = 0L;
        }

        public String toString() {
            return "NodeState(" + (Object)((Object)this.state) + ", " + this.lastConnectAttemptMs + ", " + this.failedAttempts + ", " + this.throttleUntilTimeMs + ")";
        }
    }
}

