/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.testutils;

import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class TestSourceContext<T>
implements SourceFunction.SourceContext<T> {
    private final Object checkpointLock = new Object();
    private final Object watermarkLock = new Object();
    private volatile StreamRecord<T> latestElement;
    private volatile Watermark currentWatermark;

    public void collect(T element) {
        this.latestElement = new StreamRecord(element);
    }

    public void collectWithTimestamp(T element, long timestamp) {
        this.latestElement = new StreamRecord(element, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitWatermark(Watermark mark) {
        Object object = this.watermarkLock;
        synchronized (object) {
            this.currentWatermark = mark;
            this.watermarkLock.notifyAll();
        }
    }

    public void markAsTemporarilyIdle() {
    }

    public Object getCheckpointLock() {
        return this.checkpointLock;
    }

    public void close() {
    }

    public StreamRecord<T> getLatestElement() {
        return this.latestElement;
    }

    public boolean hasWatermark() {
        return this.currentWatermark != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watermark getLatestWatermark() throws InterruptedException {
        Object object = this.watermarkLock;
        synchronized (object) {
            while (this.currentWatermark == null) {
                this.watermarkLock.wait();
            }
            Watermark wm = this.currentWatermark;
            this.currentWatermark = null;
            return wm;
        }
    }
}

