/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.testutils;

import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.connector.kafka.sink.testutils.KafkaSinkExternalContext;
import org.apache.flink.connector.testframe.external.ExternalContextFactory;
import org.testcontainers.containers.KafkaContainer;

public class KafkaSinkExternalContextFactory
implements ExternalContextFactory<KafkaSinkExternalContext> {
    private final KafkaContainer kafkaContainer;
    private final List<URL> connectorJars;

    public KafkaSinkExternalContextFactory(KafkaContainer kafkaContainer, List<URL> connectorJars) {
        this.kafkaContainer = kafkaContainer;
        this.connectorJars = connectorJars;
    }

    private String getBootstrapServer() {
        String internalEndpoints = this.kafkaContainer.getNetworkAliases().stream().map(host -> String.join((CharSequence)":", host, Integer.toString(9092))).collect(Collectors.joining(","));
        return String.join((CharSequence)",", this.kafkaContainer.getBootstrapServers(), internalEndpoints);
    }

    public KafkaSinkExternalContext createExternalContext(String testName) {
        return new KafkaSinkExternalContext(this.getBootstrapServer(), this.connectorJars);
    }
}

