/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.util;

import java.util.Properties;

public class KafkaUtils {
    public static int getIntFromConfig(Properties config, String key, int defaultValue) {
        try {
            return Integer.parseInt(config.getProperty(key, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value for configuration key='" + key + "' is not set correctly. " + "Entered value='" + config.getProperty(key) + "'. Default value='" + defaultValue + "'");
        }
    }

    public static long getLongFromConfig(Properties config, String key, long defaultValue) {
        try {
            return Long.parseLong(config.getProperty(key, Long.toString(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value for configuration key='" + key + "' is not set correctly. " + "Entered value='" + config.getProperty(key) + "'. Default value='" + defaultValue + "'");
        }
    }

    public static void checkArgument(boolean arg) {
        if (!arg) {
            throw new IllegalArgumentException();
        }
    }
}

