/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.partitioner;

import java.io.Serializable;
import org.apache.flink.streaming.connectors.kafka.partitioner.KafkaPartitioner;

public class FixedPartitioner<T>
extends KafkaPartitioner<T>
implements Serializable {
    private static final long serialVersionUID = 1627268846962918126L;
    private int targetPartition = -1;

    @Override
    public void open(int parallelInstanceId, int parallelInstances, int[] partitions) {
        if (parallelInstanceId < 0 || parallelInstances <= 0 || partitions.length == 0) {
            throw new IllegalArgumentException();
        }
        this.targetPartition = partitions[parallelInstanceId % partitions.length];
    }

    @Override
    public int partition(T next, byte[] serializedKey, byte[] serializedValue, int numPartitions) {
        if (this.targetPartition >= 0) {
            return this.targetPartition;
        }
        throw new RuntimeException("The partitioner has not been initialized properly");
    }
}

