/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals.metrics;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.streaming.connectors.kafka.internals.metrics.AvgKafkaMetricAccumulator;
import org.apache.flink.streaming.connectors.kafka.internals.metrics.MaxKafkaMetricAccumulator;
import org.apache.flink.streaming.connectors.kafka.internals.metrics.MinKafkaMetricAccumulator;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaMetricAccumulator
implements Accumulator<Void, Double>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaMetricAccumulator.class);
    protected boolean isMerged = false;
    protected double mergedValue;
    protected transient KafkaMetric kafkaMetric;

    public static DefaultKafkaMetricAccumulator createFor(Metric metric) {
        if (!(metric instanceof KafkaMetric)) {
            return null;
        }
        KafkaMetric kafkaMetric = (KafkaMetric)metric;
        Measurable measurable = DefaultKafkaMetricAccumulator.getMeasurableFromKafkaMetric(kafkaMetric);
        if (measurable == null) {
            return null;
        }
        if (measurable instanceof Max) {
            return new MaxKafkaMetricAccumulator(kafkaMetric);
        }
        if (measurable instanceof Min) {
            return new MinKafkaMetricAccumulator(kafkaMetric);
        }
        if (measurable instanceof Avg) {
            return new AvgKafkaMetricAccumulator(kafkaMetric);
        }
        return new DefaultKafkaMetricAccumulator(kafkaMetric);
    }

    protected static Measurable getMeasurableFromKafkaMetric(KafkaMetric kafkaMetric) {
        try {
            Field measurableField = kafkaMetric.getClass().getDeclaredField("measurable");
            measurableField.setAccessible(true);
            return (Measurable)measurableField.get(kafkaMetric);
        }
        catch (Throwable e) {
            LOG.warn("Unable to initialize Kafka metric: " + kafkaMetric, e);
            return null;
        }
    }

    DefaultKafkaMetricAccumulator(KafkaMetric kafkaMetric) {
        this.kafkaMetric = kafkaMetric;
    }

    public void add(Void value) {
    }

    public Double getLocalValue() {
        if (this.isMerged && this.kafkaMetric == null) {
            return this.mergedValue;
        }
        return this.kafkaMetric.value();
    }

    public void resetLocal() {
    }

    public void merge(Accumulator<Void, Double> other) {
        if (!(other instanceof DefaultKafkaMetricAccumulator)) {
            throw new RuntimeException("Trying to merge incompatible accumulators");
        }
        DefaultKafkaMetricAccumulator otherMetric = (DefaultKafkaMetricAccumulator)other;
        if (this.isMerged) {
            this.mergedValue = otherMetric.isMerged ? (this.mergedValue += otherMetric.mergedValue) : (this.mergedValue += otherMetric.getLocalValue().doubleValue());
        } else {
            this.isMerged = true;
            this.mergedValue = otherMetric.isMerged ? this.getLocalValue() + otherMetric.mergedValue : this.getLocalValue() + otherMetric.getLocalValue();
        }
    }

    public Accumulator<Void, Double> clone() {
        DefaultKafkaMetricAccumulator clone = new DefaultKafkaMetricAccumulator(this.kafkaMetric);
        clone.isMerged = this.isMerged;
        clone.mergedValue = this.mergedValue;
        return clone;
    }

    public String toString() {
        if (this.isMerged) {
            return Double.toString(this.mergedValue);
        }
        if (this.kafkaMetric == null) {
            return "null";
        }
        return Double.toString(this.kafkaMetric.value());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.isMerged = true;
        this.mergedValue = this.kafkaMetric.value();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

