/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class JsonRowSerializationSchema
implements SerializationSchema<Row> {
    private final String[] fieldNames;
    private static ObjectMapper mapper = new ObjectMapper();

    public JsonRowSerializationSchema(String[] fieldNames) {
        this.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames);
    }

    public byte[] serialize(Row row) {
        if (row.getArity() != this.fieldNames.length) {
            throw new IllegalStateException(String.format("Number of elements in the row %s is different from number of field names: %d", row, this.fieldNames.length));
        }
        ObjectNode objectNode = mapper.createObjectNode();
        for (int i = 0; i < row.getArity(); ++i) {
            JsonNode node = mapper.valueToTree(row.getField(i));
            objectNode.set(this.fieldNames[i], node);
        }
        try {
            return mapper.writeValueAsBytes((Object)objectNode);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize row", e);
        }
    }
}

