/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class JsonRowDeserializationSchema
implements DeserializationSchema<Row> {
    private final TypeInformation<Row> typeInfo;
    private final String[] fieldNames;
    private final TypeInformation<?>[] fieldTypes;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private boolean failOnMissingField;

    public JsonRowDeserializationSchema(TypeInformation<Row> typeInfo) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information");
        this.typeInfo = typeInfo;
        this.fieldNames = ((RowTypeInfo)typeInfo).getFieldNames();
        this.fieldTypes = ((RowTypeInfo)typeInfo).getFieldTypes();
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = this.objectMapper.readTree(message);
            Row row = new Row(this.fieldNames.length);
            for (int i = 0; i < this.fieldNames.length; ++i) {
                JsonNode node = root.get(this.fieldNames[i]);
                if (node == null) {
                    if (this.failOnMissingField) {
                        throw new IllegalStateException("Failed to find field with name '" + this.fieldNames[i] + "'.");
                    }
                    row.setField(i, null);
                    continue;
                }
                Object value = this.objectMapper.treeToValue((TreeNode)node, this.fieldTypes[i].getTypeClass());
                row.setField(i, value);
            }
            return row;
        }
        catch (Throwable t) {
            throw new IOException("Failed to deserialize JSON object.", t);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        return this.typeInfo;
    }

    public void setFailOnMissingField(boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
    }
}

