/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.flink.streaming.util.serialization.AbstractDeserializationSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class AvroRowDeserializationSchema
extends AbstractDeserializationSchema<Row> {
    private final Schema schema;
    private final DatumReader<SpecificRecord> datumReader;
    private final MutableByteArrayInputStream inputStream;
    private final Decoder decoder;
    private SpecificRecord record;

    public AvroRowDeserializationSchema(Class<? extends SpecificRecord> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null.");
        this.schema = SpecificData.get().getSchema(recordClazz);
        this.datumReader = new SpecificDatumReader(this.schema);
        this.record = (SpecificRecord)SpecificData.newInstance(recordClazz, (Schema)this.schema);
        this.inputStream = new MutableByteArrayInputStream();
        this.decoder = DecoderFactory.get().binaryDecoder((InputStream)this.inputStream, null);
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            this.inputStream.setBuffer(message);
            this.record = (SpecificRecord)this.datumReader.read((Object)this.record, this.decoder);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize Row.", e);
        }
        Object row = AvroRowDeserializationSchema.convertToRow(this.schema, this.record);
        return (Row)row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object convertToRow(Schema schema, Object recordObj) {
        if (recordObj instanceof GenericRecord) {
            if (schema.getType() == Schema.Type.UNION) {
                List types = schema.getTypes();
                if (types.size() != 2 || ((Schema)types.get(0)).getType() != Schema.Type.NULL || ((Schema)types.get(1)).getType() != Schema.Type.RECORD) throw new RuntimeException("Currently we only support schemas of the following form: UNION[null, RECORD]. Given: " + schema);
                schema = (Schema)types.get(1);
            } else if (schema.getType() != Schema.Type.RECORD) {
                throw new RuntimeException("Record type for row type expected. But is: " + schema);
            }
            List fields = schema.getFields();
            Row row = new Row(fields.size());
            GenericRecord record = (GenericRecord)recordObj;
            for (int i = 0; i < fields.size(); ++i) {
                Schema.Field field = (Schema.Field)fields.get(i);
                row.setField(i, AvroRowDeserializationSchema.convertToRow(field.schema(), record.get(field.pos())));
            }
            return row;
        }
        if (!(recordObj instanceof Utf8)) return recordObj;
        return recordObj.toString();
    }

    private static final class MutableByteArrayInputStream
    extends ByteArrayInputStream {
        public MutableByteArrayInputStream() {
            super(new byte[0]);
        }

        public void setBuffer(byte[] buf) {
            this.buf = buf;
            this.pos = 0;
            this.count = buf.length;
        }
    }
}

