/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Properties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public abstract class KafkaTableSource
implements StreamTableSource<Row> {
    private final String topic;
    private final Properties properties;
    private final DeserializationSchema<Row> deserializationSchema;
    private final TypeInformation<Row> typeInfo;

    KafkaTableSource(String topic, Properties properties, DeserializationSchema<Row> deserializationSchema, TypeInformation<Row> typeInfo) {
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties");
        this.deserializationSchema = (DeserializationSchema)Preconditions.checkNotNull(deserializationSchema, (String)"Deserialization schema");
        this.typeInfo = (TypeInformation)Preconditions.checkNotNull(typeInfo, (String)"Type information");
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment env) {
        FlinkKafkaConsumerBase<Row> kafkaConsumer = this.getKafkaConsumer(this.topic, this.properties, this.deserializationSchema);
        return env.addSource(kafkaConsumer);
    }

    public TypeInformation<Row> getReturnType() {
        return this.typeInfo;
    }

    abstract FlinkKafkaConsumerBase<Row> getKafkaConsumer(String var1, Properties var2, DeserializationSchema<Row> var3);

    protected DeserializationSchema<Row> getDeserializationSchema() {
        return this.deserializationSchema;
    }

    public String explainSource() {
        return "";
    }
}

