/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Properties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducerBase;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public abstract class KafkaTableSink
implements AppendStreamTableSink<Row> {
    protected final String topic;
    protected final Properties properties;
    protected SerializationSchema<Row> serializationSchema;
    protected final FlinkKafkaPartitioner<Row> partitioner;
    protected String[] fieldNames;
    protected TypeInformation[] fieldTypes;

    public KafkaTableSink(String topic, Properties properties, FlinkKafkaPartitioner<Row> partitioner) {
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"topic");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"properties");
        this.partitioner = (FlinkKafkaPartitioner)Preconditions.checkNotNull(partitioner, (String)"partitioner");
    }

    protected abstract FlinkKafkaProducerBase<Row> createKafkaProducer(String var1, Properties var2, SerializationSchema<Row> var3, FlinkKafkaPartitioner<Row> var4);

    protected abstract SerializationSchema<Row> createSerializationSchema(String[] var1);

    protected abstract KafkaTableSink createCopy();

    public void emitDataStream(DataStream<Row> dataStream) {
        FlinkKafkaProducerBase<Row> kafkaProducer = this.createKafkaProducer(this.topic, this.properties, this.serializationSchema, this.partitioner);
        dataStream.addSink(kafkaProducer);
    }

    public TypeInformation<Row> getOutputType() {
        return new RowTypeInfo(this.getFieldTypes());
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    public KafkaTableSink configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        KafkaTableSink copy = this.createCopy();
        copy.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames, (String)"fieldNames");
        copy.fieldTypes = (TypeInformation[])Preconditions.checkNotNull(fieldTypes, (String)"fieldTypes");
        Preconditions.checkArgument((fieldNames.length == fieldTypes.length ? 1 : 0) != 0, (Object)"Number of provided field names and types does not match.");
        copy.serializationSchema = this.createSerializationSchema(fieldNames);
        return copy;
    }
}

