/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.state.CheckpointListener;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.checkpoint.CheckpointedRestoring;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.kafka.config.OffsetCommitMode;
import org.apache.flink.streaming.connectors.kafka.config.OffsetCommitModes;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaCommitCallback;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionAssigner;
import org.apache.flink.streaming.util.serialization.KeyedDeserializationSchema;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkKafkaConsumerBase<T>
extends RichParallelSourceFunction<T>
implements CheckpointListener,
ResultTypeQueryable<T>,
CheckpointedFunction,
CheckpointedRestoring<HashMap<KafkaTopicPartition, Long>> {
    private static final long serialVersionUID = -6272159445203409112L;
    protected static final Logger LOG = LoggerFactory.getLogger(FlinkKafkaConsumerBase.class);
    public static final int MAX_NUM_PENDING_CHECKPOINTS = 100;
    public static final String KEY_DISABLE_METRICS = "flink.disable-metrics";
    private final List<String> topics;
    protected final KeyedDeserializationSchema<T> deserializer;
    private Map<KafkaTopicPartition, Long> subscribedPartitionsToStartOffsets;
    private SerializedValue<AssignerWithPeriodicWatermarks<T>> periodicWatermarkAssigner;
    private SerializedValue<AssignerWithPunctuatedWatermarks<T>> punctuatedWatermarkAssigner;
    private transient ListState<Tuple2<KafkaTopicPartition, Long>> offsetsStateForCheckpoint;
    private boolean enableCommitOnCheckpoints = true;
    private OffsetCommitMode offsetCommitMode;
    private StartupMode startupMode = StartupMode.GROUP_OFFSETS;
    protected Map<KafkaTopicPartition, Long> specificStartupOffsets;
    private final LinkedMap pendingOffsetsToCommit = new LinkedMap();
    private volatile transient AbstractFetcher<T, ?> kafkaFetcher;
    private volatile transient HashMap<KafkaTopicPartition, Long> restoredState;
    private volatile boolean running = true;
    private transient boolean restored = false;
    private transient Counter successfulCommits;
    private transient Counter failedCommits;
    private transient KafkaCommitCallback offsetCommitCallback;

    public FlinkKafkaConsumerBase(List<String> topics, KeyedDeserializationSchema<T> deserializer) {
        this.topics = (List)Preconditions.checkNotNull(topics);
        Preconditions.checkArgument((topics.size() > 0 ? 1 : 0) != 0, (Object)"You have to define at least one topic.");
        this.deserializer = (KeyedDeserializationSchema)Preconditions.checkNotNull(deserializer, (String)"valueDeserializer");
    }

    public FlinkKafkaConsumerBase<T> assignTimestampsAndWatermarks(AssignerWithPunctuatedWatermarks<T> assigner) {
        Preconditions.checkNotNull(assigner);
        if (this.periodicWatermarkAssigner != null) {
            throw new IllegalStateException("A periodic watermark emitter has already been set.");
        }
        try {
            ClosureCleaner.clean(assigner, (boolean)true);
            this.punctuatedWatermarkAssigner = new SerializedValue(assigner);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The given assigner is not serializable", e);
        }
    }

    public FlinkKafkaConsumerBase<T> assignTimestampsAndWatermarks(AssignerWithPeriodicWatermarks<T> assigner) {
        Preconditions.checkNotNull(assigner);
        if (this.punctuatedWatermarkAssigner != null) {
            throw new IllegalStateException("A punctuated watermark emitter has already been set.");
        }
        try {
            ClosureCleaner.clean(assigner, (boolean)true);
            this.periodicWatermarkAssigner = new SerializedValue(assigner);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The given assigner is not serializable", e);
        }
    }

    public FlinkKafkaConsumerBase<T> setCommitOffsetsOnCheckpoints(boolean commitOnCheckpoints) {
        this.enableCommitOnCheckpoints = commitOnCheckpoints;
        return this;
    }

    public FlinkKafkaConsumerBase<T> setStartFromEarliest() {
        this.startupMode = StartupMode.EARLIEST;
        this.specificStartupOffsets = null;
        return this;
    }

    public FlinkKafkaConsumerBase<T> setStartFromLatest() {
        this.startupMode = StartupMode.LATEST;
        this.specificStartupOffsets = null;
        return this;
    }

    public FlinkKafkaConsumerBase<T> setStartFromGroupOffsets() {
        this.startupMode = StartupMode.GROUP_OFFSETS;
        this.specificStartupOffsets = null;
        return this;
    }

    public FlinkKafkaConsumerBase<T> setStartFromSpecificOffsets(Map<KafkaTopicPartition, Long> specificStartupOffsets) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets);
        return this;
    }

    public void open(Configuration configuration) {
        this.offsetCommitMode = OffsetCommitModes.fromConfiguration(this.getIsAutoCommitEnabled(), this.enableCommitOnCheckpoints, ((StreamingRuntimeContext)this.getRuntimeContext()).isCheckpointingEnabled());
        switch (this.offsetCommitMode) {
            case ON_CHECKPOINTS: {
                LOG.info("Consumer subtask {} will commit offsets back to Kafka on completed checkpoints.", (Object)this.getRuntimeContext().getIndexOfThisSubtask());
                break;
            }
            case KAFKA_PERIODIC: {
                LOG.info("Consumer subtask {} will commit offsets back to Kafka periodically using the Kafka client's auto commit.", (Object)this.getRuntimeContext().getIndexOfThisSubtask());
                break;
            }
            default: {
                LOG.info("Consumer subtask {} has disabled offset committing back to Kafka. This does not compromise Flink's checkpoint integrity.", (Object)this.getRuntimeContext().getIndexOfThisSubtask());
            }
        }
        if (this.restored) {
            this.subscribedPartitionsToStartOffsets = this.restoredState;
            LOG.info("Consumer subtask {} will start reading {} partitions with offsets in restored state: {}", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.subscribedPartitionsToStartOffsets.size(), this.subscribedPartitionsToStartOffsets});
        } else {
            List<KafkaTopicPartition> kafkaTopicPartitions = this.getKafkaPartitions(this.topics);
            Preconditions.checkNotNull(kafkaTopicPartitions, (String)"TopicPartitions must not be null.");
            this.subscribedPartitionsToStartOffsets = FlinkKafkaConsumerBase.initializeSubscribedPartitionsToStartOffsets(kafkaTopicPartitions, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks(), this.startupMode, this.specificStartupOffsets);
            if (this.subscribedPartitionsToStartOffsets.size() != 0) {
                switch (this.startupMode) {
                    case EARLIEST: {
                        LOG.info("Consumer subtask {} will start reading the following {} partitions from the earliest offsets: {}", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.subscribedPartitionsToStartOffsets.size(), this.subscribedPartitionsToStartOffsets.keySet()});
                        break;
                    }
                    case LATEST: {
                        LOG.info("Consumer subtask {} will start reading the following {} partitions from the latest offsets: {}", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.subscribedPartitionsToStartOffsets.size(), this.subscribedPartitionsToStartOffsets.keySet()});
                        break;
                    }
                    case SPECIFIC_OFFSETS: {
                        LOG.info("Consumer subtask {} will start reading the following {} partitions from the specified startup offsets {}: {}", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.subscribedPartitionsToStartOffsets.size(), this.specificStartupOffsets, this.subscribedPartitionsToStartOffsets.keySet()});
                        ArrayList<KafkaTopicPartition> partitionsDefaultedToGroupOffsets = new ArrayList<KafkaTopicPartition>(this.subscribedPartitionsToStartOffsets.size());
                        for (Map.Entry<KafkaTopicPartition, Long> subscribedPartition : this.subscribedPartitionsToStartOffsets.entrySet()) {
                            if (subscribedPartition.getValue() != -915623761773L) continue;
                            partitionsDefaultedToGroupOffsets.add(subscribedPartition.getKey());
                        }
                        if (partitionsDefaultedToGroupOffsets.size() <= 0) break;
                        LOG.warn("Consumer subtask {} cannot find offsets for the following {} partitions in the specified startup offsets: {}; their startup offsets will be defaulted to their committed group offsets in Kafka.", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), partitionsDefaultedToGroupOffsets.size(), partitionsDefaultedToGroupOffsets});
                        break;
                    }
                    default: {
                        LOG.info("Consumer subtask {} will start reading the following {} partitions from the committed group offsets in Kafka: {}", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.subscribedPartitionsToStartOffsets.size(), this.subscribedPartitionsToStartOffsets.keySet()});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<T> sourceContext) throws Exception {
        if (this.subscribedPartitionsToStartOffsets == null) {
            throw new Exception("The partitions were not set for the consumer");
        }
        this.successfulCommits = this.getRuntimeContext().getMetricGroup().counter("commitsSucceeded");
        this.failedCommits = this.getRuntimeContext().getMetricGroup().counter("commitsFailed");
        this.offsetCommitCallback = new KafkaCommitCallback(){

            @Override
            public void onSuccess() {
                FlinkKafkaConsumerBase.this.successfulCommits.inc();
            }

            @Override
            public void onException(Throwable cause) {
                LOG.error("Async Kafka commit failed.", cause);
                FlinkKafkaConsumerBase.this.failedCommits.inc();
            }
        };
        if (!this.subscribedPartitionsToStartOffsets.isEmpty()) {
            AbstractFetcher<T, ?> fetcher = this.createFetcher(sourceContext, this.subscribedPartitionsToStartOffsets, this.periodicWatermarkAssigner, this.punctuatedWatermarkAssigner, (StreamingRuntimeContext)this.getRuntimeContext(), this.offsetCommitMode);
            this.kafkaFetcher = fetcher;
            if (!this.running) {
                return;
            }
            fetcher.runFetchLoop();
        } else {
            sourceContext.emitWatermark(new Watermark(Long.MAX_VALUE));
            Object waitLock = new Object();
            while (this.running) {
                try {
                    Object object = waitLock;
                    synchronized (object) {
                        waitLock.wait();
                    }
                }
                catch (InterruptedException e) {
                    if (this.running) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void cancel() {
        this.running = false;
        if (this.kafkaFetcher != null) {
            this.kafkaFetcher.cancel();
        }
    }

    public void close() throws Exception {
        try {
            this.cancel();
        }
        finally {
            super.close();
        }
    }

    public final void initializeState(FunctionInitializationContext context) throws Exception {
        if (!this.restored) {
            this.restored = context.isRestored();
        }
        OperatorStateStore stateStore = context.getOperatorStateStore();
        this.offsetsStateForCheckpoint = stateStore.getSerializableListState("_default_");
        if (context.isRestored()) {
            if (this.restoredState == null) {
                this.restoredState = new HashMap();
                for (Tuple2 kafkaOffset : (Iterable)this.offsetsStateForCheckpoint.get()) {
                    this.restoredState.put((KafkaTopicPartition)kafkaOffset.f0, (Long)kafkaOffset.f1);
                }
                LOG.info("Setting restore state in the FlinkKafkaConsumer.");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using the following offsets: {}", this.restoredState);
                }
            }
        } else {
            LOG.info("No restore state for FlinkKafkaConsumer.");
        }
    }

    public final void snapshotState(FunctionSnapshotContext context) throws Exception {
        if (!this.running) {
            LOG.debug("snapshotState() called on closed source");
        } else {
            this.offsetsStateForCheckpoint.clear();
            AbstractFetcher<T, ?> fetcher = this.kafkaFetcher;
            if (fetcher == null) {
                for (Map.Entry<KafkaTopicPartition, Long> subscribedPartition : this.subscribedPartitionsToStartOffsets.entrySet()) {
                    this.offsetsStateForCheckpoint.add((Object)Tuple2.of((Object)subscribedPartition.getKey(), (Object)subscribedPartition.getValue()));
                }
                if (this.offsetCommitMode == OffsetCommitMode.ON_CHECKPOINTS) {
                    this.pendingOffsetsToCommit.put((Object)context.getCheckpointId(), this.restoredState);
                }
            } else {
                HashMap<KafkaTopicPartition, Long> currentOffsets = fetcher.snapshotCurrentState();
                if (this.offsetCommitMode == OffsetCommitMode.ON_CHECKPOINTS) {
                    this.pendingOffsetsToCommit.put((Object)context.getCheckpointId(), currentOffsets);
                }
                for (Map.Entry<KafkaTopicPartition, Long> kafkaTopicPartitionLongEntry : currentOffsets.entrySet()) {
                    this.offsetsStateForCheckpoint.add((Object)Tuple2.of((Object)kafkaTopicPartitionLongEntry.getKey(), (Object)kafkaTopicPartitionLongEntry.getValue()));
                }
            }
            if (this.offsetCommitMode == OffsetCommitMode.ON_CHECKPOINTS) {
                while (this.pendingOffsetsToCommit.size() > 100) {
                    this.pendingOffsetsToCommit.remove(0);
                }
            }
        }
    }

    public final void restoreState(HashMap<KafkaTopicPartition, Long> restoredOffsets) {
        LOG.info("{} (taskIdx={}) restoring offsets from an older version.", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getRuntimeContext().getIndexOfThisSubtask());
        this.restoredState = restoredOffsets.isEmpty() ? new HashMap() : restoredOffsets;
        this.restored = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} (taskIdx={}) restored offsets from an older Flink version: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.getRuntimeContext().getIndexOfThisSubtask(), this.restoredState});
        }
    }

    public final void notifyCheckpointComplete(long checkpointId) throws Exception {
        block9: {
            if (!this.running) {
                LOG.debug("notifyCheckpointComplete() called on closed source");
                return;
            }
            AbstractFetcher<T, ?> fetcher = this.kafkaFetcher;
            if (fetcher == null) {
                LOG.debug("notifyCheckpointComplete() called on uninitialized source");
                return;
            }
            if (this.offsetCommitMode == OffsetCommitMode.ON_CHECKPOINTS) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Committing offsets to Kafka/ZooKeeper for checkpoint " + checkpointId);
                }
                try {
                    int posInMap = this.pendingOffsetsToCommit.indexOf((Object)checkpointId);
                    if (posInMap == -1) {
                        LOG.warn("Received confirmation for unknown checkpoint id {}", (Object)checkpointId);
                        return;
                    }
                    HashMap offsets = (HashMap)this.pendingOffsetsToCommit.remove(posInMap);
                    for (int i = 0; i < posInMap; ++i) {
                        this.pendingOffsetsToCommit.remove(0);
                    }
                    if (offsets == null || offsets.size() == 0) {
                        LOG.debug("Checkpoint state was empty.");
                        return;
                    }
                    fetcher.commitInternalOffsetsToKafka(offsets, this.offsetCommitCallback);
                }
                catch (Exception e) {
                    if (!this.running) break block9;
                    throw e;
                }
            }
        }
    }

    protected abstract AbstractFetcher<T, ?> createFetcher(SourceFunction.SourceContext<T> var1, Map<KafkaTopicPartition, Long> var2, SerializedValue<AssignerWithPeriodicWatermarks<T>> var3, SerializedValue<AssignerWithPunctuatedWatermarks<T>> var4, StreamingRuntimeContext var5, OffsetCommitMode var6) throws Exception;

    protected abstract List<KafkaTopicPartition> getKafkaPartitions(List<String> var1);

    protected abstract boolean getIsAutoCommitEnabled();

    public TypeInformation<T> getProducedType() {
        return this.deserializer.getProducedType();
    }

    protected static Map<KafkaTopicPartition, Long> initializeSubscribedPartitionsToStartOffsets(List<KafkaTopicPartition> kafkaTopicPartitions, int indexOfThisSubtask, int numParallelSubtasks, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets) {
        HashMap<KafkaTopicPartition, Long> subscribedPartitionsToStartOffsets = new HashMap<KafkaTopicPartition, Long>(kafkaTopicPartitions.size());
        for (KafkaTopicPartition kafkaTopicPartition : kafkaTopicPartitions) {
            if (KafkaTopicPartitionAssigner.assign(kafkaTopicPartition, numParallelSubtasks) != indexOfThisSubtask) continue;
            if (startupMode != StartupMode.SPECIFIC_OFFSETS) {
                subscribedPartitionsToStartOffsets.put(kafkaTopicPartition, startupMode.getStateSentinel());
                continue;
            }
            if (specificStartupOffsets == null) {
                throw new IllegalArgumentException("Startup mode for the consumer set to " + (Object)((Object)StartupMode.SPECIFIC_OFFSETS) + ", but no specific offsets were specified");
            }
            Long specificOffset = specificStartupOffsets.get(kafkaTopicPartition);
            if (specificOffset != null) {
                subscribedPartitionsToStartOffsets.put(kafkaTopicPartition, specificOffset - 1L);
                continue;
            }
            subscribedPartitionsToStartOffsets.put(kafkaTopicPartition, -915623761773L);
        }
        return subscribedPartitionsToStartOffsets;
    }

    protected static void logPartitionInfo(Logger logger, List<KafkaTopicPartition> partitionInfos) {
        HashMap<String, Integer> countPerTopic = new HashMap<String, Integer>();
        for (KafkaTopicPartition partition : partitionInfos) {
            Integer count = (Integer)countPerTopic.get(partition.getTopic());
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            countPerTopic.put(partition.getTopic(), count);
        }
        StringBuilder sb = new StringBuilder("Consumer is going to read the following topics (with number of partitions): ");
        for (Map.Entry e : countPerTopic.entrySet()) {
            sb.append((String)e.getKey()).append(" (").append(e.getValue()).append("), ");
        }
        logger.info(sb.toString());
    }

    @VisibleForTesting
    void setSubscribedPartitions(List<KafkaTopicPartition> allSubscribedPartitions) {
        Preconditions.checkNotNull(allSubscribedPartitions);
        this.subscribedPartitionsToStartOffsets = new HashMap<KafkaTopicPartition, Long>();
        for (KafkaTopicPartition partition : allSubscribedPartitions) {
            this.subscribedPartitionsToStartOffsets.put(partition, null);
        }
    }

    @VisibleForTesting
    Map<KafkaTopicPartition, Long> getSubscribedPartitionsToStartOffsets() {
        return this.subscribedPartitionsToStartOffsets;
    }

    @VisibleForTesting
    HashMap<KafkaTopicPartition, Long> getRestoredState() {
        return this.restoredState;
    }

    @VisibleForTesting
    OffsetCommitMode getOffsetCommitMode() {
        return this.offsetCommitMode;
    }
}

