/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.testutils;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.functions.MapFunction;

public class PartitionValidatingMapper
implements MapFunction<Integer, Integer> {
    private static final long serialVersionUID = 1088381231244959088L;
    private final Set<Integer> myPartitions = new HashSet<Integer>();
    private final int numPartitions;
    private final int maxPartitions;

    public PartitionValidatingMapper(int numPartitions, int maxPartitions) {
        this.numPartitions = numPartitions;
        this.maxPartitions = maxPartitions;
    }

    public Integer map(Integer value) throws Exception {
        int partition = value % this.numPartitions;
        this.myPartitions.add(partition);
        if (this.myPartitions.size() > this.maxPartitions) {
            throw new Exception("Error: Elements from too many different partitions: " + this.myPartitions + ". Expect elements only from " + this.maxPartitions + " partitions");
        }
        return value;
    }
}

