/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.testutils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.io.avro.generated.Address;
import org.apache.flink.api.io.avro.generated.Colors;
import org.apache.flink.api.io.avro.generated.User;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.types.Row;

public final class AvroTestUtils {
    private static String NAMESPACE = "org.apache.flink.streaming.connectors.kafka";

    public static Schema createFlatAvroSchema(String[] fieldNames, TypeInformation[] fieldTypes) {
        SchemaBuilder.FieldAssembler fieldAssembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"BasicAvroRecord").namespace(NAMESPACE)).fields();
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        for (int i = 0; i < fieldNames.length; ++i) {
            Schema schema = ReflectData.get().getSchema((Type)fieldTypes[i].getTypeClass());
            Schema unionSchema = Schema.createUnion(Arrays.asList(nullSchema, schema));
            fieldAssembler.name(fieldNames[i]).type(unionSchema).noDefault();
        }
        return (Schema)fieldAssembler.endRecord();
    }

    public static Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> getSimpleTestData() {
        Address addr = Address.newBuilder().setNum(42).setStreet("Main Street 42").setCity("Test City").setState("Test State").setZip("12345").build();
        Row rowAddr = new Row(5);
        rowAddr.setField(0, (Object)42);
        rowAddr.setField(1, (Object)"Main Street 42");
        rowAddr.setField(2, (Object)"Test City");
        rowAddr.setField(3, (Object)"Test State");
        rowAddr.setField(4, (Object)"12345");
        Tuple3 t = new Tuple3();
        t.f0 = Address.class;
        t.f1 = addr;
        t.f2 = rowAddr;
        return t;
    }

    public static Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> getComplexTestData() {
        Address addr = Address.newBuilder().setNum(42).setStreet("Main Street 42").setCity("Test City").setState("Test State").setZip("12345").build();
        Row rowAddr = new Row(5);
        rowAddr.setField(0, (Object)42);
        rowAddr.setField(1, (Object)"Main Street 42");
        rowAddr.setField(2, (Object)"Test City");
        rowAddr.setField(3, (Object)"Test State");
        rowAddr.setField(4, (Object)"12345");
        User user = User.newBuilder().setName("Charlie").setFavoriteNumber(null).setFavoriteColor("blue").setTypeLongTest(1337L).setTypeDoubleTest(1.337).setTypeNullTest(null).setTypeBoolTest(false).setTypeArrayString(new ArrayList<CharSequence>()).setTypeArrayBoolean(new ArrayList<Boolean>()).setTypeNullableArray(null).setTypeEnum(Colors.RED).setTypeMap(new HashMap<CharSequence, Long>()).setTypeFixed(null).setTypeUnion(null).setTypeNested(addr).build();
        Row rowUser = new Row(15);
        rowUser.setField(0, (Object)"Charlie");
        rowUser.setField(1, null);
        rowUser.setField(2, (Object)"blue");
        rowUser.setField(3, (Object)1337L);
        rowUser.setField(4, (Object)1.337);
        rowUser.setField(5, null);
        rowUser.setField(6, (Object)false);
        rowUser.setField(7, new ArrayList());
        rowUser.setField(8, new ArrayList());
        rowUser.setField(9, null);
        rowUser.setField(10, (Object)Colors.RED);
        rowUser.setField(11, new HashMap());
        rowUser.setField(12, null);
        rowUser.setField(13, null);
        rowUser.setField(14, (Object)rowAddr);
        Tuple3 t = new Tuple3();
        t.f0 = User.class;
        t.f1 = user;
        t.f2 = rowUser;
        return t;
    }
}

