/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkFixedPartitioner;
import org.junit.Assert;
import org.junit.Test;

public class TestFlinkFixedPartitioner {
    @Test
    public void testMoreFlinkThanBrokers() {
        FlinkFixedPartitioner part = new FlinkFixedPartitioner();
        int[] partitions = new int[]{0};
        part.open(0, 4);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc1", null, null, null, partitions));
        part.open(1, 4);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc2", null, null, null, partitions));
        part.open(2, 4);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc3", null, null, null, partitions));
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc3", null, null, null, partitions));
        part.open(3, 4);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc4", null, null, null, partitions));
    }

    @Test
    public void testFewerPartitions() {
        FlinkFixedPartitioner part = new FlinkFixedPartitioner();
        int[] partitions = new int[]{0, 1, 2, 3, 4};
        part.open(0, 2);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc1", null, null, null, partitions));
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc1", null, null, null, partitions));
        part.open(1, 2);
        Assert.assertEquals((long)1L, (long)part.partition((Object)"abc1", null, null, null, partitions));
        Assert.assertEquals((long)1L, (long)part.partition((Object)"abc1", null, null, null, partitions));
    }

    @Test
    public void testMixedCase() {
        FlinkFixedPartitioner part = new FlinkFixedPartitioner();
        int[] partitions = new int[]{0, 1};
        part.open(0, 3);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc1", null, null, null, partitions));
        part.open(1, 3);
        Assert.assertEquals((long)1L, (long)part.partition((Object)"abc1", null, null, null, partitions));
        part.open(2, 3);
        Assert.assertEquals((long)0L, (long)part.partition((Object)"abc1", null, null, null, partitions));
    }
}

