/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import kafka.server.KafkaServer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.streaming.util.serialization.KeyedDeserializationSchema;
import org.apache.flink.streaming.util.serialization.KeyedDeserializationSchemaWrapper;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;

public abstract class KafkaTestEnvironment {
    protected static final String KAFKA_HOST = "localhost";

    public abstract void prepare(int var1, Properties var2, boolean var3);

    public void prepare(int numberOfKafkaServers, boolean secureMode) {
        this.prepare(numberOfKafkaServers, null, secureMode);
    }

    public abstract void shutdown();

    public abstract void deleteTestTopic(String var1);

    public abstract void createTestTopic(String var1, int var2, int var3, Properties var4);

    public void createTestTopic(String topic, int numberOfPartitions, int replicationFactor) {
        this.createTestTopic(topic, numberOfPartitions, replicationFactor, new Properties());
    }

    public abstract Properties getStandardProperties();

    public abstract Properties getSecureProperties();

    public abstract String getBrokerConnectionString();

    public abstract String getVersion();

    public abstract List<KafkaServer> getBrokers();

    public <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> topics, DeserializationSchema<T> deserializationSchema, Properties props) {
        return this.getConsumer(topics, (KeyedDeserializationSchema<T>)new KeyedDeserializationSchemaWrapper(deserializationSchema), props);
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(String topic, KeyedDeserializationSchema<T> readSchema, Properties props) {
        return this.getConsumer(Collections.singletonList(topic), readSchema, props);
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(String topic, DeserializationSchema<T> deserializationSchema, Properties props) {
        return this.getConsumer(Collections.singletonList(topic), deserializationSchema, props);
    }

    public abstract <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> var1, KeyedDeserializationSchema<T> var2, Properties var3);

    public abstract <T> StreamSink<T> getProducerSink(String var1, KeyedSerializationSchema<T> var2, Properties var3, FlinkKafkaPartitioner<T> var4);

    public abstract <T> DataStreamSink<T> produceIntoKafka(DataStream<T> var1, String var2, KeyedSerializationSchema<T> var3, Properties var4, FlinkKafkaPartitioner<T> var5);

    public abstract KafkaOffsetHandler createOffsetHandler();

    public abstract void restartBroker(int var1) throws Exception;

    public abstract int getLeaderToShutDown(String var1) throws Exception;

    public abstract int getBrokerId(KafkaServer var1);

    public abstract boolean isSecureRunSupported();

    public static interface KafkaOffsetHandler {
        public Long getCommittedOffset(String var1, int var2);

        public void setCommittedOffset(String var1, int var2, long var3);

        public void close();
    }
}

