/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.KafkaTableSource;
import org.apache.flink.streaming.connectors.kafka.testutils.AvroTestUtils;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class KafkaTableSourceTestBase {
    private static final String TOPIC = "testTopic";
    private static final String[] FIELD_NAMES = new String[]{"mylong", "mystring", "myboolean", "mydouble", "missingField"};
    private static final TypeInformation<?>[] FIELD_TYPES = new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO};
    private static final Properties PROPERTIES = KafkaTableSourceTestBase.createSourceProperties();

    @Test
    public void testKafkaTableSource() {
        KafkaTableSource kafkaTableSource = (KafkaTableSource)Mockito.spy((Object)this.createTableSource());
        StreamExecutionEnvironment env = (StreamExecutionEnvironment)Mockito.mock(StreamExecutionEnvironment.class);
        kafkaTableSource.getDataStream(env);
        ((StreamExecutionEnvironment)Mockito.verify((Object)env)).addSource((SourceFunction)Matchers.any(this.getFlinkKafkaConsumer()));
        ((KafkaTableSource)Mockito.verify((Object)kafkaTableSource)).getKafkaConsumer((String)Matchers.eq((Object)TOPIC), (Properties)Matchers.eq((Object)PROPERTIES), (DeserializationSchema)Matchers.any(this.getDeserializationSchema()));
    }

    protected abstract KafkaTableSource createTableSource(String var1, Properties var2, TypeInformation<Row> var3);

    protected abstract Class<DeserializationSchema<Row>> getDeserializationSchema();

    protected abstract Class<FlinkKafkaConsumerBase<Row>> getFlinkKafkaConsumer();

    private KafkaTableSource createTableSource() {
        return this.createTableSource(TOPIC, PROPERTIES, (TypeInformation<Row>)Types.ROW((String[])FIELD_NAMES, FIELD_TYPES));
    }

    private static Properties createSourceProperties() {
        Properties properties = new Properties();
        properties.setProperty("zookeeper.connect", "dummy");
        properties.setProperty("group.id", "dummy");
        return properties;
    }

    static /* synthetic */ String[] access$000() {
        return FIELD_NAMES;
    }

    static /* synthetic */ TypeInformation[] access$100() {
        return FIELD_TYPES;
    }

    public static class AvroSpecificRecord
    extends SpecificRecordBase {
        public static Schema SCHEMA$ = AvroTestUtils.createFlatAvroSchema(KafkaTableSourceTestBase.access$000(), KafkaTableSourceTestBase.access$100());
        public Long mylong;
        public String mystring;
        public Boolean myboolean;
        public Double mydouble;
        public Long missingField;

        public Schema getSchema() {
            return null;
        }

        public Object get(int field) {
            return null;
        }

        public void put(int field, Object value) {
        }
    }
}

